#include <stdio.h>
#include "Temperature.h"
#include "SmartRestConf.h"
#include "logging.h"

// Cut-off for avoiding sending similar sensor reading.
#define THRESHOLD_PERCENT_TEMP 0.02
// Timeout for forcing a sending even if readings are similar [seconds].
#define TIME_LIMIT_TEMP 900

static inline bool valueChanged(float V0, float V1)
{
        if (abs(V0-V1) <= abs(V0)*THRESHOLD_PERCENT_TEMP)
                return false;
        else
                return true;
}

int Temperature::read(char *buf, size_t maxLen, char *status, size_t num)
{
        static const char *fmt = "105,%ld,%f\r\n";
        if (!deviceReady)
                return 0;

        float data = sensor.temp();
        float t_interval = timer.read();
        if (!valueChanged(oldValue, data) && t_interval < TIME_LIMIT_TEMP) {
                return 0;
        }
        size_t l = snprintf(buf, maxLen, fmt, deviceID, data);
        if (status) {
                snprintf(status, num, "Send Temp %.2f", data);
        }
        oldValue = data;
        timer.reset();
        return l;
}