#include <stdio.h>
#include "Signal.h"
#include "SmartRestConf.h"
#include "LCDDisplay.h"
#include "DeviceInfo.h"
#include "logging.h"

// Cut-off for avoiding sending similar sensor reading.
#define THRESHOLD_PERCENT_SIG 0.06
// Timeout for forcing a sending even if readings are similar [seconds].
#define TIME_LIMIT_SIG 900

static inline bool valueChanged(int *V0, int *V1)
{
        if (abs(V0[0]-V1[0]) <= abs(V0[0])*THRESHOLD_PERCENT_SIG &&
            abs(V0[1]-V1[1]) <= abs(V0[1])*THRESHOLD_PERCENT_SIG)
                return false;
        else
                return true;
}

int Signal::read(char *buf, size_t maxLen, char *status, size_t num)
{
        static const char *fmt = "104,%ld,%d,%d\r\n";
        static char signal[27] = {0};
        DeviceInfo::SignalQuality *p = deviceInfo.signalQuality();

        if (p && p->rssi)
                snprintf(signal, sizeof(signal), "Network: %d dBm", p->rssi);
        else
                strncpy(signal, "Network: no coverage", sizeof(signal));
        if (strcmp(LCDDisplay::inst().getSecondLine(), signal)) {
                LCDDisplay::inst().setSecondLine(signal);
        }
        if (p == NULL || p->rssi == 0)
                return -1;

        int data[2] = { p->rssi, p->ber };
        float t_interval = timer.read();
        if (!valueChanged(oldValues, data) && t_interval < TIME_LIMIT_SIG) {
                return 0;
        }

        size_t l = snprintf(buf, maxLen, fmt, deviceID, data[0], data[1]);
        if (status) {
                snprintf(status, num, "Send dBm %d,%d", data[0], data[1]);
        }
        oldValues[0] = data[0];
        oldValues[1] = data[1];
        timer.reset();
        return l;
}