#include <string.h>
#include "DeviceInfo.h"
#include "logging.h"

extern MDMSerial *pMdm;

const char * DeviceInfo::cellId()
{
    if (!pMdm->checkNetStatus(&_netStatus)) {
        return NULL;
    }
    if (snprintf(_cellId, sizeof(_cellId), "%X", _netStatus.ci) < 1)
        return NULL;
    return _cellId;
}

DeviceInfo::SignalQuality* DeviceInfo::signalQuality(bool realTime)
{
    if (!realTime && _signalQuality.rssi)
        return &_signalQuality;

    memset(&_signalQuality, 0, sizeof(DeviceInfo::SignalQuality));
    if (!pMdm->checkNetStatus(&_netStatus)) {
        aError("Check network status!\n");
        return NULL;
    }
    _signalQuality.rssi = _netStatus.rssi;
    _signalQuality.ber = _netStatus.ber;
    return &_signalQuality;
}