#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "DeviceBootstrap.h"
#include "Storage.h"
#include "LCDDisplay.h"
#include "SmartRestConf.h"
#include "SmartRestSocket.h"
#include "lex.h"
#include "logging.h"

// Device bootstrap tenant, username and password
#define BOOTSTRAP_TENANT "management"
#define BOOTSTRAP_USERNAME "devicebootstrap"
#define BOOTSTRAP_PASSWORD "Fhdt1bb1f"

bool DeviceBootstrap::bootstrap()
{
    char tenant[CREDENTIAL_LENGTH];
    char username[CREDENTIAL_LENGTH];
    char password[CREDENTIAL_LENGTH];
    if (loadCredential(tenant, username, password, CREDENTIAL_LENGTH)) {
        setAuth(tenant, username, password);
        aInfo("Set auth: %s/%s:%s(%s)\n", srTenant, srUsername, srPassword, srAuthStr);
        return true;
    } else if (obtainFromPlatform()) {
        if (!saveCredential(srTenant, srUsername, srPassword, CREDENTIAL_LENGTH))
            aError("Save credentials!\n");
        return true;
    } else {
        return false;
    }
}

bool DeviceBootstrap::obtainFromPlatform()
{
        char buf[SMARTREST_SIZE];
        char buf2[SMARTREST_BODY_SIZE];
        SmartRestSocket sock;
        int l2 = snprintf(buf2, sizeof(buf2), "61,%s\r\n", deviceInfo.imei());

        // set authorization for bootstrap
        setAuth(BOOTSTRAP_TENANT, BOOTSTRAP_USERNAME, BOOTSTRAP_PASSWORD);
        LCDDisplay::inst().setLines("Bootstrap", deviceInfo.imei());
        for (unsigned short i = 0; i < 255; ++i) {
                int l = snprintf(buf, sizeof(buf), fmtSmartRest, "/s", l2, buf2);
                l = sock.sendAndReceive(buf, l, sizeof(buf));
                if (l <= 0) continue;

                const char *p = skipHTTPHeader(buf);
                if (p) {
                        Token tok;
                        p = lex(p, tok);
                        if (tok.len==2 && strncmp(tok.p, "70", tok.len)==0) {
                                for (unsigned short j = 0; *p && j < 3; ++j) {
                                        p = lex(p, tok);
                                }
                                if (tok.type == Token::STRING) {
                                        char tenant[CREDENTIAL_LENGTH] = {0};
                                        char username[CREDENTIAL_LENGTH] = {0};
                                        char password[CREDENTIAL_LENGTH] = {0};
                                        strncpy(tenant, tok.p, tok.len);
                                        p = lex(p, tok);
                                        if (tok.type == Token::STRING)
                                                strncpy(username, tok.p, tok.len);
                                        else
                                                return false;
                                        p = lex(p, tok);
                                        if (tok.type == Token::STRING)
                                                strncpy(password, tok.p, tok.len);
                                        else
                                                return false;
                                        setAuth(tenant, username, password);
                                        LCDDisplay::inst().setLines("Bootstrap Success", srTenant, srUsername);
                                        aInfo("%s/%s:%s\n", srTenant, srUsername, srPassword);
                                        return true;
                                } else
                                        return false;
                        }
                }
        }
        return false;
}