#ifndef REPORTTHREAD_H
#define REPORTTHREAD_H
#include "Operation.h"
#include "SmartRestConf.h"
#include "SmartRestSocket.h"
#define OPERATION_DICT_SIZE 10

class OperationDict
{
public:
        OperationDict(): count(0) {}
        const Operation& operator [](unsigned short i) const { return opl[i]; }
        Operation *set(long id, OperationState state) {
                short i = count-1;
                for (; i >= 0; --i) {
                        if (opl[i].identifier == id)
                                break;
                }
                if (i >= 0) {
                        opl[i].identifier = id;
                        opl[i].state = state;
                        return &opl[i];
                } else if (count < OPERATION_DICT_SIZE) {
                        i = count++;
                        opl[i].identifier = id;
                        opl[i].state = state;
                        return &opl[i];
                } else
                        return NULL;
        }
        void clear() { count = 0; }
        bool full() const { return count >= OPERATION_DICT_SIZE; }
        unsigned short size() const { return count; }
        virtual ~OperationDict() {}
private:
        unsigned short count;
        Operation opl[OPERATION_DICT_SIZE];
};

class ReportThread
{
public:
        ReportThread(OperationPool& pool) : ipool(pool), dict(), sock(),
                thread(ReportThread::threadWrapper, this) {
                strncpy(uri, "/s", sizeof(uri));
        }
        virtual ~ReportThread() { }
        void threadFunc();
        static void threadWrapper(const void *p) { ((ReportThread*)p)->threadFunc(); }
private:
        char uri[4];
        OperationPool& ipool;
        OperationDict dict;
        char buf[SMARTREST_SIZE];
        char buf2[SMARTREST_BODY_SIZE];
        SmartRestSocket sock;
        Thread thread;
};

#endif /* REPORTTHREAD_H */