#include <stdio.h>

#include "mbed.h"
#include "rtos.h"
#include "MDM.h"
#include "GPS.h"

#include "DeviceInfo.h"
#include "Storage.h"
#include "MbedAgent.h"
#include "GPSTracker.h"
#include "LCDDisplay.h"
#include "logging.h"

/**
 * SIM PIN. Null for no pin.
 */
#define SIM_PIN NULL

/**
 * SIM GPRS login data. Leave commented out for automatic setting.
 */
//#define SIM_APN ""
//#define SIM_USER ""
//#define SIM_PASS ""

MDMSerial* pMdm = NULL;
//CYASSL_CTX *pCtx = NULL;

static unsigned short getMNCLen(const char *imsi)
{
    if (strncmp(imsi, "310", 3) != 0) // Non American ISMI
        return 2;
    else
        return 3;
}

static void enableDebug()
{
        setLevel(A_DEBUG);
        if (pMdm)
            pMdm->setDebug(3);
}

static void disableDebug()
{
       setLevel(A_WARNING);
       if (pMdm)
           pMdm->setDebug(0);
}

static void shutdown()
{
//    CyaSSL_CTX_free(pCtx);
//    CyaSSL_Cleanup();
    pMdm->disconnect();
    pMdm->powerOff();
}

//static int send(CYASSL *ssl, char *buf, int size, void* ctx)
//{
//        int sockfd = *(int*)ctx;
//        int ret = pMdm->socketSend(sockfd, buf, size);
//        printf("[send](%d, %p): %d/%d\n", sockfd, ssl, ret, size);
//        if (ret >= 0)
//                return ret;
//        else
//                return CYASSL_CBIO_ERR_GENERAL;
//}
//
//static int recv(CYASSL *ssl, char *buf, int maxSize, void* ctx)
//{
//        int sockfd = *(int*)ctx;
//        int ret = pMdm->socketRecv(sockfd, buf, maxSize);
//        printf("[recv](%d, %p): %d/%d\n", sockfd, ssl, ret, maxSize);
//        if (ret >= 0)
//                return ret;
//        else
//                return CYASSL_CBIO_ERR_GENERAL;
//}

int main()
{
    LCDDisplay::inst().setLines("Mbed Agent V2.2", srHost);
//    set_time(1256729737);
    MDMRtos<MDMSerial> mdm;
    pMdm = &mdm;
    InterruptIn joystickUp(A2);
    InterruptIn joystickDown(A3);

//    CyaSSL_Init();
//    pCtx = CyaSSL_CTX_new(CyaTLSv1_2_client_method());
//    CyaSSL_Debugging_ON();
//    if (pCtx == NULL) {
//        shutdown();
//        return 1;
//    }
//    CyaSSL_CTX_set_verify(pCtx, SSL_VERIFY_NONE, 0);
//    CyaSSL_CTX_set_cipher_list(pCtx, "DHE-RSA-AES128-GCM-SHA256:ECDH-RSA-AES128-SHA:DHE-RSA-AES128-SHA:DHE-RSA-AES256-SHA");
//    CyaSSL_SetIORecv(pCtx, recv);
//    CyaSSL_SetIOSend(pCtx, send);

    MDMParser::DevStatus devStatus;
    if (!mdm.init(SIM_PIN, &devStatus)) {
        LCDDisplay::inst().setLines("Modem Init Failure", "No SIM card found", "Or SIM has PIN");
        shutdown();
        return 2;
    }
    joystickUp.rise(&enableDebug);
    joystickDown.rise(&disableDebug);
    
    DigitalIn fireButton(D4);
    if (fireButton) {
        LCDDisplay::inst().setLines("Factory resetting...");
        Thread::wait(2000); // wait for Disk I/O to be ready
        if (resetCredential()) {
            LCDDisplay::inst().setLines("Reset Success");
        } else {
            LCDDisplay::inst().setLines("Reset Failure");
        }
        shutdown();
        return 0;
    }
    LCDDisplay::inst().setLines("Register Network...", "IMEI", devStatus.imei);
    if (!mdm.registerNet()) {
        LCDDisplay::inst().setLines("No Network Coverage");
        shutdown();
        return 3;
    }

    LCDDisplay::inst().setLines("Join Network");
#ifdef SIM_APN
    if (mdm.join(SIM_APN, SIM_USER, SIM_PASS) == NOIP) {
#else
    if (mdm.join() == NOIP) {
#endif
        char s[8] = "Unknown";
        const char *p = devStatus.imsi;
        if (p) {
            snprintf(s, sizeof(s), "%.*s-%.*s", 3, p, getMNCLen(p), p+3);
        }
        LCDDisplay::inst().setLines("Unknown APN Settting", "MCC-MNC:", s);
        shutdown();
        return 4;
    }

    {
        DeviceInfo deviceInfo(devStatus);
        MbedAgent agent(deviceInfo);

        LCDDisplay::inst().setLines("Agent Init");
        if (!agent.init()) {
            shutdown();
            return 5;
        }
        LCDDisplay::inst().setLines("Agent Run");
        int ret = 0;
        for (uint8_t tries = 3; tries; --tries) {
            ret = agent.run();
            if (ret == 0) {
                char status[27];
                snprintf(status, sizeof(status), "Tenant: %s", srTenant);
                LCDDisplay::inst().setFirstLine(status);
                agent.loop();
                break;
            }
        }
        shutdown();
        return ret;
    }
}
