#ifndef STORAGE_H
#define STORAGE_H

#include <stddef.h>

/** loads credentials from persistent memory */
bool loadCredential(char *tenant, char *username, char *password, size_t len);

/** saves credentials to persistent memory */
bool resetCredential();

/** removes credentials from persistent memory */
bool saveCredential(const char *tenant, const char *username,
                    const char *password, size_t len);

/** loads configuration from persistent memory */
bool loadConfigFile(char *cfg, size_t len);

/** saves configuration to persistent memory */
bool saveConfigFile(char *cfg, size_t len);

#endif