#ifndef CONFIGPARSER_H
#define CONFIGPARSER_H
#include "lex.h"
#include "dict.h"

class ConfigParser
{
public:
        Dict dict;
public:
        ConfigParser() : dict(), parseOK(true) {}
        virtual ~ConfigParser() {}
        bool parse(const char*);
protected:
        typedef void (ConfigParser::*PtrParseFunc) (Token&);
        void parseKey(Token&);
        void parseAssignOp(Token&);
        void parseValue(Token&);
        void parseSemiColon(Token&);
        void parseError(Token&);
        void parseRecover(Token&);
private:
        bool parseOK;
        PtrParseFunc ptrPF;
        char key[MAX_KEY_LEN];
        char value[MAX_VALUE_LEN];
};

#endif /* CONFIGPARSER_H */