#ifndef DEVICEINTEGRATION_H
#define DEVICEINTEGRATION_H

#include "SmartRest.h"
#include "SmartRestTemplate.h"
#include "DeviceInfo.h"

class DeviceIntegration
{
public:
    DeviceIntegration(SmartRest& c, SmartRestTemplate& t, DeviceInfo& d):
    _init(false), _tpl(t), _client(c), _deviceInfo(d) {}
    bool init();
    bool integrate();

protected:
    bool deviceExisting();
    bool createDevice();
    bool addGlobalIdentifier();
    bool updateDevice();

private:
    bool _init;
    SmartRestTemplate& _tpl;
    SmartRest& _client;
    DeviceInfo& _deviceInfo;
};

#endif