#ifndef DEVICEINFO_H
#define DEVICEINFO_H
#include "MDM.h"

class DeviceInfo
{
public:
    typedef struct {
        int rssi;  // RSSI [dBm]
        int ber;   // BER [%]
    } SignalQuality;

    DeviceInfo(MDMParser::DevStatus& devStatus) {
        *_cellId = 0;
        memcpy(&_devStatus, &devStatus, sizeof(MDMParser::DevStatus));
        memset(&_netStatus, 0, sizeof(MDMParser::NetStatus));
        memset(&_signalQuality, 0, sizeof(DeviceInfo::SignalQuality));
    }
    
    const char* cellId();
    const char* iccid() const { return _devStatus.ccid; }
    const char* imei() const { return _devStatus.imei; }
    const char* imsi() const { return _devStatus.imsi; }
    SignalQuality * signalQuality(bool realTime=true);

private:
    MDMParser::DevStatus _devStatus;
    MDMParser::NetStatus _netStatus;
    char _cellId[9];
    SignalQuality _signalQuality;
};

#endif