#ifndef DICH_H
#define DICH_H
#include <string.h>
#include <stdio.h>
#define MAX_KEY_LEN 50
#define MAX_VALUE_LEN 50
#define MAX_ITEM_SIZE 3

class Dict
{
public:
        struct Item {
                char key[MAX_KEY_LEN];
                char value[MAX_VALUE_LEN];
        };

        Dict(): count(0) {}
        
        Dict(const Dict& d): count(0) {
                *this = d;
        }

        Dict& operator= (const Dict& d) {
                clear();
                for (size_t i = 0; i < d.size(); ++i) {
                        const Item* p = d.at(i);
                        set(p->key, p->value);
                }
                return *this;
        }

        const Item* at(const size_t i) const {
                if (i < count) return &items[i];
                else return NULL;
        }

        const Item* get(const char *k) const {
                size_t i = find(k);
                if (i < count)
                        return &items[i];
                else
                        return NULL;
        }

        const Item* set(const char *k, const char *v) {
                size_t i = find(k);
                if (i < count) {
                        strncpy(items[i].value, v, MAX_VALUE_LEN);
                        return &items[i];
                } else if (count < MAX_ITEM_SIZE){
                        ++count;
                        strncpy(items[i].key, k, MAX_KEY_LEN);
                        strncpy(items[i].value, v, MAX_VALUE_LEN);
                        return &items[i];
                } else
                        return NULL;
        }

        size_t dump(char* buf) const {
                size_t l = 0;
                for (size_t i = 0; i < count; ++i) {
                        l += sprintf(buf+l, "%s=%s;", items[i].key, items[i].value);
                }
                buf[l] = 0;
                return l;
        }

        size_t maxSize() const { return MAX_ITEM_SIZE; }
        size_t size() const { return count; }
        bool empty() const { return count==0; }
        bool full() const { return count == MAX_ITEM_SIZE; }
        void clear() { count = 0; }
        virtual ~Dict() {}
protected:
        size_t find(const char* k) const {
                for (size_t i = 0; i < count; ++i) {
                        if (strncmp(items[i].key, k, MAX_KEY_LEN) == 0)
                                return i;
                }
                return count;
        }
private:
        Item items[MAX_ITEM_SIZE];
        size_t count;
};

#endif /* DICH_H */