#ifndef SMARTRESTSOCKET_H
#define SMARTRESTSOCKET_H
#include "TCPSocketConnection.h"

class SmartRestSocket : public TCPSocketConnection
{
public:
        SmartRestSocket(): TCPSocketConnection() {
                memset(cachedIP, 0, sizeof(cachedIP));
        }
        virtual ~SmartRestSocket() {}
        int connect();
        int sendOnly(char *buf, int size);
        int sendAndReceive(char *buf, int size, int maxSize);
        /* Set the timeout for the socket.
           \param _timeout in milliseconds, -1 for no timeout.
         */
        void setBlocking(int timeout = -1) {
                if (timeout == -1)
                        Socket::set_blocking(true);
                else
                        Socket::set_blocking(false, timeout);
        }
private:
        char cachedIP[16];
};

#endif /* SMARTRESTSOCKET_H */