#ifndef CONFIGSYNC_H
#define CONFIGSYNC_H
#include "AbstractReporter.h"
#include "ConfigParser.h"

class ConfigSync : public AbstractReporter
{
private:
        ConfigSync(): dict(), cp(), changed(true) {}
public:
        virtual ~ConfigSync() {}
        virtual bool init() {
                loadConfiguration();
                return true;
        }
        static ConfigSync& inst() {
                static ConfigSync _ref;
                return _ref;
        }
        virtual const char* name() const { return "Conf"; }
        virtual int read(char*, size_t, char*, size_t);
        bool updateConfiguration(const char*);
protected:
        void resetConfiguration();
        void loadConfiguration();
        void saveConfiguration() const;
private:
        Dict dict;
        ConfigParser cp;
        bool changed;
};

#endif /* CONFIGSYNC_H */