#include <stdio.h>
#include "Location.h"
#include "SmartRestConf.h"
#include "logging.h"

// Percentage cut-off for avoiding sending similar sensor readings.
#define THRESHOLD_PERCENT_LOC 0.05
// Timeout for forcing a sending even if readings are similar [seconds].
#define TIME_LIMIT_LOC 900

static inline bool valueChanged(float *V0, float *V1)
{
        if (abs(V0[0]-V1[0]) <= abs(V0[0])*THRESHOLD_PERCENT_LOC &&
            abs(V0[1]-V1[1]) <= abs(V0[1])*THRESHOLD_PERCENT_LOC &&
            abs(V0[2]-V1[2]) <= abs(V0[2])*THRESHOLD_PERCENT_LOC)
                return false;
        else
                return true;
}

int Location::read(char *buf, size_t maxLen, char *status, size_t num)
{
        static const char *fmt = "108,%ld,%.2f,%.6f,%.6f\r\n109,%ld,%.2f,%.6f,%.6f";
        GPSTracker::Position pos;
        if (!gpsTracker.position(&pos)) {
                return 0;
        }
        float data[3] = { pos.altitude, pos.latitude, pos.longitude };

        float t_interval = timer.read();
        if (!valueChanged(oldValues, data) && t_interval < TIME_LIMIT_LOC) {
                return 0;
        }

        size_t l = snprintf(buf, maxLen, fmt, deviceID, data[0], data[1],
                            data[2], deviceID, data[0], data[1], data[2]);
        if (status) {
                snprintf(status, num, "Send GPS %.1f,%.1f,%.1f",
                         data[0], data[1], data[2]);
        }
        oldValues[0] = data[0];
        oldValues[1] = data[1];
        oldValues[2] = data[2];
        timer.reset();
        return l;
}