#ifndef ACCELERATION_H
#define ACCELERATION_H
#include "mbed.h"
#include "MMA7660.h"
#include "AbstractReporter.h"


class Acceleration: public AbstractReporter
{
public:
        Acceleration(): deviceReady(false), sensor(SDA, SCL), timer() {
                oldValues[0] = 0;
                oldValues[1] = 0;
                oldValues[2] = 0;
                timer.start();
        }
        virtual ~Acceleration() {}
        virtual bool init() {
                deviceReady = sensor.testConnection();
                return deviceReady;
        }
        virtual const char* name() const { return "Acc"; }
        virtual int read(char*, size_t, char*, size_t);
private:
        bool deviceReady;
        MMA7660 sensor;
        float oldValues[3];
        Timer timer;
};

#endif /* ACCELERATION_H */