#include <stdio.h>
#include "rtos.h"
#include "SmartRestConf.h"
#include "Acceleration.h"
#include "logging.h"

// Percentage cut-off for avoiding sending similar sensor reading.
#define THRESHOLD_PERCENT_ACCE 0.1
// Timeout for forcing a sending even if readings are similar [seconds].
#define TIME_LIMIT_ACCE 900

static inline bool valueChanged(float *V0, float *V1)
{
//        if (abs(oldValues[0]-data[0]) <= abs(oldValues[0])*THRESHOLD_PERCENT_ACCE ||
//            abs(oldValues[1]-data[1]) <= abs(oldValues[1])*THRESHOLD_PERCENT_ACCE ||
//            abs(oldValues[2]-data[2]) <= abs(oldValues[2])*THRESHOLD_PERCENT_ACCE) {
        if ((0.15 > abs(V1[0]) || abs(V0[0]-V1[0]) <= abs(V0[0])*THRESHOLD_PERCENT_ACCE) &&
            (0.10 > abs(V1[1]) || abs(V0[1]-V1[1]) <= abs(V0[1])*THRESHOLD_PERCENT_ACCE))
                return false;
        else
                return true;
}

int Acceleration::read(char *buf, size_t maxLen, char *status, size_t num)
{
        static const char *fmt = "106,%ld,%f,%f,%f\r\n";
        if (!deviceReady)
                return 0;
        float data[3] = {0.0, 0.0, 0.0};
//        float min[3] = {100, 100, 100};
//        float max[3] = {0, 0, 0};
//        const unsigned short N = 10;
//        for (unsigned short i = 0; i < N; ++i) {
//                float d[3] = {0, 0, 0};
//                sensor.readData(d);
//                for (unsigned short j = 0; j < 3; ++j) {
//                        data[j] += d[j];
//                        if (d[j] < min[j]) min[j] = d[j];
//                        if (d[j] > max[j]) max[j] = d[j];
//                }
//                Thread::wait(5);
//        }
//        data[0] = (data[0]-min[0]-max[0]) / (N-2);
//        data[1] = (data[1]-min[1]-max[1]) / (N-2);
//        data[2] = (data[2]-min[2]-max[2]) / (N-2);
        sensor.readData(data);
        float t_interval = timer.read();
        if (!valueChanged(oldValues, data) && t_interval < TIME_LIMIT_ACCE) {
                return 0;
        }

        size_t l = snprintf(buf, maxLen, fmt, deviceID, data[0], data[1], data[2]);
        if (status) {
                snprintf(status, num, "Send Acc %.1f,%.1f,%.1f",
                         data[0], data[1], data[2]);
        }
        oldValues[0] = data[0];
        oldValues[1] = data[1];
        oldValues[2] = data[2];
        timer.reset();
        return l;
}