/*
 * SmartRest.h
 *
 * Created on: Nov 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 * @file SmartRest.h
 * The main SmartRest facade class. This class is abstract, because the
 * actual implementation has to supply a client.
 */

#ifndef SMARTREST_H
#define SMARTREST_H

#include "config.h"
#include <stddef.h>
#include <stdint.h>
#include "AbstractSmartRest.h"
#include "AbstractClient.h"
#include "Parser.h"

/**
 * The main SmartRest client implementation.
 */
class SmartRest : public AbstractSmartRest
{
	public:
		/**
		 * Creates a new generic SmartRest object.
		 * @param client the abstract client to use
		 * @param identifier the device identifier
		 */
		SmartRest(AbstractClient&, const char*);

		uint8_t setAuthorization(const char*, const char*);
#ifdef SMARTREST_TRANSACTIONAL
		uint8_t request(const DataGenerator&, const char* = NULL);
		uint8_t request(const DataGenerator&, Aggregator&, const char* = NULL);
#endif
		uint8_t bootstrap(const DataGenerator&);
		uint8_t send(const DataGenerator&, const char* = NULL);
		uint8_t stream(const char*, const Record&, const char* = NULL);
		uint8_t receive(ParsedRecord&);
		void stop();
		const char * getIdentifier();

	protected:
		uint8_t beginRequest(const char*, const char*);
		uint8_t awaitResponse();
		bool setMoGid(ParsedRecord&);

	private:
		AbstractClient& _client;
		AbstractDataSource *_source;
		Parser _parser;
		const char *_identifier;
		char _mogid[8 * sizeof(long) + 1];
};

#endif
