/*
 * MbedDataSink.h
 *
 * Created on: Feb 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef MBEDDATASINK_H
#define MBEDDATASINK_H

#include <stddef.h>
#include "AbstractDataSink.h"
#include "TCPSocketConnection.h"

#define MBED_SINK_BUFFER_SIZE 60

class MbedClient;

class MbedDataSink : public AbstractDataSink
{
public:
    MbedDataSink(TCPSocketConnection& sock);
    ~MbedDataSink();
    
    size_t write(char c);
    size_t write(void *buf, size_t length);
    size_t write(const char *str);
    size_t write(unsigned long number);
    
    
protected:
    bool flush();
    bool send();
    void reset();

private:
    TCPSocketConnection& _sock;
    char _buf[MBED_SINK_BUFFER_SIZE];
    size_t _len;

friend class MbedClient;
};

#endif
