/*
 * Record.h
 *
 * Created on: Nov 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef RECORD_H
#define RECORD_H

#include "config.h"
#include "DataGenerator.h"
#include "Value.h"

/**
 * A record which can be read and serialized. 
 */
class Record : public DataGenerator
{
	public:
		virtual ~Record() { };

		/**
		 * Returns the number of values in this record.
		 * @return number of values in this record
		 */
		virtual size_t values() const = 0;

		/**
		 * Returns the value object by index
		 * @param index the index of the value
		 * @return a copy of a value object
		 */
		virtual const Value& value(size_t) const = 0;

		size_t writeTo(AbstractDataSink&) const;
		size_t writtenLength() const;

		virtual Record* copy() const = 0;

		/**
		 * Test if record contains any values.
		 */
		operator bool() const;
};

#endif
