/*
 * MbedClient.h
 *
 * Created on: Feb 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef MBEDCLIENT_H
#define MBEDCLIENT_H

#include <stdint.h>
#include "AbstractClient.h"
#include "TCPSocketConnection.h"
#include "MbedDataSource.h"
#include "MbedDataSink.h"
#include "HTTPResponseFilter.h"

#define MBCL_DBG(...) do { printf("\033[32mMbedClient:\033[39m "); printf(__VA_ARGS__); printf("\r\n"); } while (0);
//#define MBCL_DBG(fmt, ...)

class MbedClient : public AbstractClient {
public:
    MbedClient(const char*, uint16_t, uint8_t);
    ~MbedClient();

    uint8_t setAuthorization(const char*, const char*);
    uint8_t beginRequest();
    uint8_t beginStream(const char*);
    uint8_t sendIdentifier(const char*);
    uint8_t sendData(const DataGenerator& generator);
    uint8_t endRequest();
    uint8_t awaitResponse();
    AbstractDataSource& receiveData();
    void stop();

protected:
    bool connect();
    bool send(const char *str);
    bool sendRequestHeader(const char*);
    bool sendBasicAuth();

private:
    uint8_t internalError();
    uint8_t connectionError();

private:
    const char *_host, *_username, *_password;
    uint16_t _port, _tries, _state;
    bool _isStreamRequest;
    TCPSocketConnection _sock;
    MbedDataSource _source;
    MbedDataSink _sink;
    HTTPResponseFilter _filter;
};

#endif
