/*
 * MbedDataSource.cpp
 *
 * Created on: Feb 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "MbedDataSource.h"
#include "stdio.h"

MbedDataSource::MbedDataSource(TCPSocketConnection& sock) :
    _sock(sock),
    _timeout(0),
    _isTimedOut(false)
{
    _offset = _len = 0;
}

MbedDataSource::~MbedDataSource()
{
}

char MbedDataSource::read()
{
    while (_offset == _len) {
        if (!receive())
            return 0;
    }
    
    return _buf[_offset++];
}

uint8_t MbedDataSource::status()
{
    if (!_sock.is_connected())
        return DS_STATUS_CLOSED;
    
    if (_isTimedOut)
        return DS_STATUS_TIMEOUT;
    
    return DS_STATUS_OK;
}

void MbedDataSource::setTimeout(size_t timeout)
{
    _timeout = timeout;
}

bool MbedDataSource::receive()
{
    int ret;

    if (status() != DS_STATUS_OK)
        return false;
    
    _sock.set_blocking(true, _timeout);
    ret = _sock.receive(_buf, MBED_SOURCE_BUFFER_SIZE);
    
    if (ret < 0) {
        _isTimedOut = true;
        return false;
    }
    
    _len = (size_t)ret;
    _offset = 0;
    
    return true;
}

void MbedDataSource::reset()
{
    _len = _offset = 0;
    _isTimedOut = false;
}
