/*
 * HTTPResponseFilter.h
 *
 * Created on: Feb 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef HTTPRESPONSEFILTER_H
#define HTTPRESPONSEFILTER_H

#include <stddef.h>
#include "AbstractDataSource.h"

#define RESPF_STATE_INIT 0
#define RESPF_STATE_READ_STATUS 1
#define RESPF_STATE_READ_HEADERS 2

/**
 * Reads and evaluates a HTTP response.
 * The read() and status() methods allow access to the response content
 * without HTTP headers.
 */
class HTTPResponseFilter : public AbstractDataSource
{
public:
    HTTPResponseFilter(AbstractDataSource& source);
    ~HTTPResponseFilter();
    
    char read();
    uint8_t status();

    uint16_t readStatus();
    bool skipHeaders();
    
    void reset();

private:
    AbstractDataSource& _source;
    uint8_t _state;
    size_t _length, _read;
};

#endif
