/*
 * ComposedRecord.h
 *
 * Created on: Nov 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef COMPOSEDRECORD_H
#define COMPOSEDRECORD_H

#include "config.h"
#include "DataGenerator.h"
#include "Record.h"
#include "Value.h"

#ifndef SMARTREST_COMPOSED_INITIAL_CAPACITY
#define SMARTREST_COMPOSED_INITIAL_CAPACITY 10
#endif
#ifndef SMARTREST_COMPOSED_MEMORY_INCREMENT
#define SMARTREST_COMPOSED_MEMORY_INCREMENT 5
#endif
//#define SMARTREST_COMPOSED_FIXED_SIZE 25

/**
 * This value set collects values and serializes them into a SmartRequest.
 * 
 * Example 1 (low memory usage):
 * @code
 * // this record does not copy added values into the heap because the
 * // lifetime of the instance does not exceed the lifetime of its added
 * // values.
 * ComposedRecord record(false);
 * IntegerValue msgId(100);
 * CharValue str("Hello World!");
 * FloatValue num(3.1415, 2);
 * record.add(msgId).add(str).add(num);
 * @encode
 * 
 * Example 2 (short form):
 * @code
 * // this record needs to copy added values due to the limited
 * // lifetime of temporary objects.
 * ComposedRecord record(true);
 * record.add(IntegerValue(100)).add(CharValue("Hello World!");
 * record.add(FloatValue(3.1415, 2));
 * @encode
 */
class ComposedRecord : public Record
{
	public:
		ComposedRecord(bool = false);
		~ComposedRecord();

		bool add(const Value&);
		void clear();

		size_t values() const;
		const Value& value(size_t) const;

		ComposedRecord* copy() const;

	private:
#ifndef SMARTREST_COMPOSED_FIXED_SIZE
		const Value **_values;
		size_t _capacity;
#else
		const Value *_values[SMARTREST_COMPOSED_FIXED_SIZE];
#endif
		size_t _count;
		bool _alloc;
};

#endif
