#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
#include "QEI.h"
#include "Rtc_Ds1307.h"
#include "string.h"
#include <Pulse1.h>

//DigitalIn Irda_int(PTB0);
//DebouncedIn Irda_int(PTB0);
PulseInOut irda(PTB0);// Sensor infrarrojo
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
Rtc_Ds1307 rtc(PTE0, PTE1);
QEI wheel (PTA13, PTD5, NC, 624);
DebouncedIn button_enco(PTC17);
DigitalOut myled(LED1);

int numP[35];//cadena para almacenar todos los tiempos que conforman los bits de datos
int numbin[35];
int i1;
int header=0; 
char r;
char cadena[34];
char cadena1[34];
//char Read[]="0000000011111111111000100001110111";
char uno[]="0000000011111111001100001100111111";
char dos[]="0000000011111111000110001110011111";
char tres[]="0000000011111111011110101000010111";
char cuatro[]="0000000011111111000100001110111111";
char cinco[]="0000000011111111001110001100011111";
char seis[]="0000000011111111010110101010010111";
char siete[]="0000000011111111010000101011110111";
char set[]="0000000011111111100100000110111111";
int mode=0;
int numb=34;
int s=0;
//
int C1=0x0C;
int m;
int Conf=0;  // 0: Alarma y 1:Reloj
int Lugar=0; // Definen el punto en el cual va el programa
int i=0;
int j=1;      //Cuenta las alarmas
int Select=1;   //Alarma Seleccionada
int StarReadIR=0;
int visual=0;  //0: Reloj y 1:Alarm
int alarma=0;  //0: Desactivar y 1:Posponer
int main()
{
    myled=1;
    j=1;
    Rtc_Ds1307::Time_rtc tm2 = {};
    Rtc_Ds1307::Time_rtc tm = {};
    Rtc_Ds1307::Time_rtc Alarm[8] = {};
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    lcd.locate(0,0);
    lcd.printf("--Alarmas --Hora"); 
    rtc.getTime(tm); //lee el tiempo del DS1307
 
    while(1)
    {
        
        switch (Lugar)
        {
            case 0:
                m=wheel.getPulses();  // m son los datos del encoder
                if(m!=0 && Conf==0){
                    Conf=1;
                    wheel.reset();  
                    m=0;              
                }
                
                if(m!=0 && Conf==1){
                    Conf=0;
                    wheel.reset();  
                    m=0;              
                }
                
                if(Conf==0){
                    
                    lcd.locate(11,0);
                    lcd.printf("-");                    
                    lcd.locate(1,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                    
                }
                
                 if(Conf==1){
                    
                    lcd.locate(1,0);
                    lcd.printf("-");                    
                    lcd.locate(11,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                }
                
                if (button_enco.falling()){  //si se pulsa boton encoder
                    Lugar++;
                    m=0;       
                }
            
            break;
            
            case 1:
                switch(i)
                {
                    case 0:                     
                        if(Conf==0) // ALARMA
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Config. Alarmas ");
                            wait(1);
                            lcd.cls();
                            i++;
                            lcd.locate(0,0);
                            lcd.printf("Dia: ");
                            m=0;                             
                        }
                
                        if(Conf==1) //RELOJ
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Config. Hora   ");
                            wait(1);
                            i++;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Dia: ");
                            m=0;
                            
                        }    
 
                    break;
                    case 1: // Dia
                        m=0;
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.date=tm.date+m;
                            if(tm.date>31)
                            {
                                tm.date=31;
                            }
                            if(tm.date<1)
                            {
                                tm.date=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(5,0);
                        lcd.printf("%02d   ",tm.date);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Mes: ");
                            
                        }
                    break;
                    case 2: // Mes
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.mon=tm.mon+m;
                            if(tm.mon>12)
                            {
                                tm.mon=12;
                            }
                            if(tm.mon<1)
                            {
                                tm.mon=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(7,0);
                        lcd.printf("%02d",tm.mon);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Year: ");
                            
                        }
                    
                    break;
                    
                    case 3: //Año
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.year=tm.year+m;
                            
                            if(tm.year<2000)
                            {
                                tm.year=2000;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%02d",tm.year);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Hora: ");
                            
                            
                        }
                    
                    break;
                    
                    case 4: //HORA
                        m=0;
                        m=wheel.getPulses();       
                        if (m!=0) 
                        {
                            tm.hour+= m;
                            if(tm.hour>23)
                            {
                                tm.hour=23;
                            }
                            if(tm.hour<0)
                            {
                                tm.hour=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%02d",tm.hour);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Minuto: ");
                            //tm.min=0;
                        }
                    
                    break;
                    
                    case 5: //MINUTOS
                        m=0;
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.min=tm.min+m;
                            if(tm.min>59)
                            {
                                tm.min=59;
                            }
                            if(tm.min<0)
                            {
                                tm.min=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%02d",tm.min);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Segundo: ");
                            //tm.sec=0;
                        }
                    
                    break;
                    
                    
                    case 6: //SEGUNDOS
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            tm.sec=tm.sec+m;
                            if(tm.sec>59)
                            {
                                tm.sec=59;
                            }
                            if(tm.sec<0)
                            {
                                tm.sec=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%02d",tm.sec);
                        
                        if (button_enco.falling())
                        {
                            ///////////////////
                            if(Conf==0)
                            {
                                Alarm[j]=tm;
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("Alarma %d config. ",j);
                                wait(1);
                                i=0;
                                m=0;
                                if(j>=7)
                                {
                                Lugar++;
                                }
                                j++;
                                lcd.cls();
                                                          
                            }
                
                            if(Conf==1)
                            {   
                                rtc.setTime(tm, true, false);
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("Hora config.  ");
                                wait(1);
                                i=0;
                                m=0;
                                Lugar=0;
                                lcd.locate(0,0);
                                lcd.printf("--Alarmas --Hora");                                
                            } 
                           
                           ///////////////////
                        }
                    
                    break;
                   
                }            
            break;
            
            case 2: // Muestra la hora y la alarma, ademas se cumprueba el estado de la alarma
                rtc.getTime(tm2); //Lee el reloj
                
                           
                if(visual==0)
                {    
                    lcd.locate(0,0);                        
                    lcd.printf("Hora:   ");
                    lcd.locate(8,0);    
                    lcd.printf("%02d:",tm2.hour);
                    lcd.printf("%02d:",tm2.min);
                    lcd.printf("%02d",tm2.sec); 
                    
                    lcd.locate(0,1);
                    lcd.printf("%02d/",tm.mon);
                    lcd.printf("%02d/",tm.date);
                    lcd.printf("%02d",tm.year);
                    wait(0.1);
                    //////////
                    m=wheel.getPulses();
                    if(m!=0)
                    {
                        visual=1;
                        wheel.reset();  
                        m=0;
                    }
                }
                
                if(visual==1)
                {
                    lcd.locate(0,1);    
                    lcd.printf("     ");
                    lcd.locate(8,0);    
                    lcd.printf("%02d:",Alarm[Select].hour);
                    lcd.printf("%02d:",Alarm[Select].min);
                    lcd.printf("%02d",Alarm[Select].sec);
                    
                    lcd.locate(0,1);
                    lcd.printf("%02d/",Alarm[Select].mon);
                    lcd.printf("%02d/",Alarm[Select].date);
                    lcd.printf("%02d",Alarm[Select].year);
                    wait(0.1);
                    ////
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        visual=0;
                        wheel.reset();  
                        m=0;                                       
                    }
                }
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////Se comprueba el estado de la alarma///////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////                
                if( (tm2.date==Alarm[Select].date)&&(tm2.mon==Alarm[Select].mon)&&(tm2.year==Alarm[Select].year)&&(tm2.hour==Alarm[Select].hour)&&(tm2.min==Alarm[Select].min)&&(tm2.sec==Alarm[Select].sec) )
                {
                    Lugar++;
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma Activa!!!");
                    wait(1);
                    lcd.locate(0,0);
                    lcd.printf("->Desactivar    ");                       
                    lcd.locate(0,1);                        
                    lcd.printf("--Aplazar       ");
                    m=0;
                }
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
/////////////////////////////////////////////Inicializar la lectura del IRDA///////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //StarReadIR=1;               
                if (button_enco.falling())
                        {
                           Lugar=0;
                           wheel.reset();
                           m=0;
                           myled=1;
                           i=0;
                           j=1;
                           lcd.cls();
                           lcd.locate(0,0);
                           lcd.printf("--Alarma  --Hora");    
                        }
 //               if (header==0)
   //                 {
     //                   StarReadIR=1;
       //             }
                        
                  if(!mode)
                  {
                         header = irda.read_low_us(8000);
                         if(header!=-1)
                         {
                             StarReadIR=1;
                             lcd.cls();
                             lcd.locate(0,0);
                             lcd.printf("  Select Alarm  ");
                         }else{
                             header = 0;
                         }
                  }
          
                 
            break;
            
            case 3: //Desactivar o aplazar la alarma 
                
                if(alarma==0) //Desactivar
                {
                    myled=1;
                    wait(0.5);
                    myled=0;
                    wait(0.5);
                                        
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        alarma=1;
                        m=0;
                        wheel.reset();
                        
                        lcd.locate(1,0);
                        lcd.printf("-");                    
                        lcd.locate(1,1);
                        lcd.printf(">");                                          
                    }
                }
                          
                ///////////////////
                
                if(alarma==1) //Posponer
                {
                    myled=1;
                    wait(0.5);
                    myled=0;
                    wait(0.5);
                                        
                    m=wheel.getPulses();
                    if(m!=0)
                    {                        
                        alarma=0;
                        m=0;
                        wheel.reset();
                        
                        lcd.locate(1,0);
                        lcd.printf(">");                    
                        lcd.locate(1,1);
                        lcd.printf("-");                                          
                    }
                }
                
                if (button_enco.falling())
                {
                    if(alarma==0) //Desactivar
                    {
                        Lugar=2; //Volver a mostrar el tiempo
                        wheel.reset();
                        m=0;
                        myled=1;
                        lcd.cls();                          
                    }
                    if(alarma==1) //Posponer
                    {
                        Lugar=2;  //Volver a mostrar el tiempo
                        rtc.getTime(tm2);
                        if(tm.min!=58)
                        {
                            Alarm[Select].min=tm2.min+2;
                        }
                        if(tm.min==59)
                        {
                            Alarm[Select].min=0;
                            Alarm[Select].hour=tm2.hour+1;
                        }
                        Alarm[Select].sec=tm2.sec;
                        lcd.cls();
                        alarma=0;
                        myled=1;   
                    }                    
                }
            break;
        }
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////Lectura del sensor IRDA///////////////////////////////////////////////////////////////////////  
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        while (StarReadIR)
        {
        fflush( stdin );
        lop1:  if(!mode){
               header = irda.read_high_us(); 
               if(header>3500) goto seguir1;                        
               goto lop1;
               }
                      
        seguir1:
               for(i1=0;i1<numb;++i1){  
               numP[i1] = irda.read_high_us();    //funcion para leer un pulso alto
               if (numP[i1]<1000){
                    s=0;
                    r='0';
               }else{
                    s=1;
                    r='1';
               }
               numbin[i1]=s;
               cadena[i1]=r;                                  
               }
               if (!strcmp(cadena,uno)){
               Select=1;    
               lcd.locate(8,1);
               lcd.printf("%d",Select);
               goto seguir1;
               }else if (!strcmp(cadena,dos)){
               Select=2;
               lcd.locate(8,1);
               lcd.printf("%d",Select);
               goto seguir1;
               }else if (!strcmp(cadena,tres)){
               Select=3;
               lcd.locate(8,1);
               lcd.printf("%d",Select);
               goto seguir1;
               }else if (!strcmp(cadena,cuatro)){
               Select=4;
               lcd.locate(8,1);
               lcd.printf("%d",Select);
               goto seguir1;
               }else if (!strcmp(cadena,cinco)){
               Select=5;
               lcd.locate(8,1);
               lcd.printf("%d",Select);
               goto seguir1;
               }else if (!strcmp(cadena,seis)){
               Select=6;
               lcd.locate(8,1);
               lcd.printf("%d",Select);
               goto seguir1;
               }else if (!strcmp(cadena,siete)){
               Select=7;
               lcd.locate(8,1);
               lcd.printf("%d",Select);
               goto seguir1;   
               }else if(!strcmp(cadena,set)){
               Lugar=2;
               StarReadIR=0;
               header=0;
               lcd.cls();
               break; 
               }       
        }                   
    }          
}