#ifndef SNAKEENGINE_H
#define SNAKEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Snake.h"
#include "Food.h"

extern Snake snake;
extern Food food;
extern Gamepad pad;



class SnakeEngine
{
    public:
    
    SnakeEngine();
    ~SnakeEngine();
        
    void init();
    void draw(N5110 &lcd);
    void moving();
    void getJoysitck();
    void changeDirection();
    bool over;
    
    bool isEatFood(int x,int y);
    bool isCrashWall (int x,int y);
    bool isSelf(int x,int y);
    void addLength();
    
    private:
    
    int nextPoint_X;
    int nextPoint_Y;
    bool addTail;
    
    int snakeBody;
    float Joysitck_X;
    float Joysitck_Y;
    int _x;
    int _y;  
    
};

#endif