#include "SnakeEngine.h"

#define WIDTH 55
#define LENGTH 6

//this class is used to integrate the funtion of snake and food
//integrate init
//integrate draw
//also the class give the main body to play the game 
//how to move snake
//how to eat food
//how to lose
//how to win

SnakeEngine::SnakeEngine()
{

}

SnakeEngine::~SnakeEngine()
{

}

//integrate init

void SnakeEngine::init()
{
    snake.init();
    food.init();
}

//function to let the sanke moving

void SnakeEngine::moving()
{
   // the next step which the snake will going 
   nextPoint_X = 0;
   nextPoint_Y = 0;
   
   // if the sanke eat food and need to add tail
   addTail = false;
   // count of sanke body
   snakeBody = 0;
   
   //get the next loction according to the location and direction of the sanke head 
   nextPoint_X = snake.snakePoint_X[snake.snakeLength -1] + 5*snake.snakeDirection[0][0];
   nextPoint_Y = snake.snakePoint_Y[snake.snakeLength -1] + snake.snakeDirection[0][1];
   
   //what happen when snake eat food
   if (SnakeEngine::isEatFood(nextPoint_X,nextPoint_Y))
        {
           SnakeEngine::addLength();
        }
    
     //what happen when snake crashwall
   if (SnakeEngine::isCrashWall(nextPoint_X,nextPoint_Y))
        {
           over = true;
           printf("loose \n");           
        }
        
     //what happen when snake crash itself
   if (SnakeEngine::isSelf(nextPoint_X,nextPoint_Y))
        {
           over = true;
           printf("loose \n");           
        }
    
    // if the sanke do not eat food it moves to the next point
   while (!addTail)
   {
       for( snakeBody = 0; snakeBody < snake.snakeLength -1; snakeBody++)
       {
           snake.snakePoint_X[snakeBody] = snake.snakePoint_X[snakeBody+1];
           snake.snakePoint_Y[snakeBody] = snake.snakePoint_Y[snakeBody+1];
        }
        if (snakeBody == snake.snakeLength -1)
        {
             printf("addTail = true");
             addTail = true;
             break;
        }
    }
    
    //change the head of the snake
    snake.snakePoint_X[snake.snakeLength -1] = nextPoint_X;
    snake.snakePoint_Y[snake.snakeLength -1] = nextPoint_Y;
}

//bool if the snake point and food point equal return ture
bool SnakeEngine::isEatFood(int x, int y)
{
     return (x == food.foodPoint_X && y == food.foodPoint_Y)? true:false;
}

//bool if the snake point and wall point equal return ture
bool SnakeEngine::isCrashWall(int x, int y)
{
   if (x < 0 ||x >= WIDTH || y < 0 || y >= LENGTH) //gameWidth gameHight
    {
        return true;
    }
    return false;
}

//bool if the snake point and it self equal return ture

bool SnakeEngine::isSelf(int x, int y)
{
    for (int i = 0; i < snake.snakeLength - 1; i++)
    {
        if (x == snake.snakePoint_X[i] && y == snake.snakePoint_Y[i])
        {
            return true;
        }
    }
    return false;    
}



void SnakeEngine::addLength()
{
    addTail = true;
    snake.snakeLength++;
    food.init();
}

// give the need data from the joystick
void SnakeEngine::getJoysitck()
{
    Vector2D place = pad.get_coord();

    Joysitck_X = (place.x)*10; // left -1 right 1
    //printf("Joysitck_X = %f       ", Joysitck_X);
    Joysitck_Y= (place.y)*10;  //// up 1 down -1
    //printf("Joysitck_Y = %f \n", Joysitck_Y); 
}

// change the dirction of the snake accoring to the joystick
void SnakeEngine::changeDirection()
{
    _x = (int)Joysitck_X;
    _y = (int)Joysitck_Y;
    
    // { -1 = left 1 = right 0 = not this direction, 1 = down -1 = up 0 = not this direction}
    if ( snake.snakeDirection[0][0] != 0)
    {
        if ( _y > 7)
        {
            snake.snakeDirection[0][0] = 0;
            snake.snakeDirection[0][1] = -1;
            printf("go up\n");
        }
        else if ( _y < -7)
        {
            snake.snakeDirection[0][0] = 0;
            snake.snakeDirection[0][1] = 1;
            printf("go down\n");
        }
        else
        {
            snake.snakeDirection[0][0] = snake.snakeDirection[0][0];
            snake.snakeDirection[0][1] = snake.snakeDirection[0][1];
        }
    }
    else if ( snake.snakeDirection[0][1] != 0)
    {
        if ( _x > 7)
        {
            snake.snakeDirection[0][0] = 1;
            snake.snakeDirection[0][1] = 0;
            printf("go right\n");
        }
         else if ( _x < -7)
        {
            snake.snakeDirection[0][0] = -1;
            snake.snakeDirection[0][1] = 0;
            printf("go left\n");
         }
          else
        {
             snake.snakeDirection[0][0] = snake.snakeDirection[0][0];
             snake.snakeDirection[0][1] = snake.snakeDirection[0][1];
        }
    }

}

//integrate draw
//also draw the frame of the game

void SnakeEngine::draw(N5110 &lcd)
{
    lcd.clear();
    snake.draw(lcd);
    food.draw(lcd);
    lcd.drawLine(0,0,0,48,2);
    lcd.drawLine(0,0,60,0,2);
    lcd.drawLine(60,48,60,0,2);
    lcd.drawLine(60,47,0,47,2);    
    lcd.refresh();
}