/*
 * An example showing how to use the CANnucleo library:
 *
 * Two affordable (less than $3 on ebay) STM32F103C8T6 boardss (20kB SRAM, 64kB Flash),
 * (see [https://developer.mbed.org/users/hudakz/code/STM32F103C8T6_Hello/] for more details)
 * are connected to the same CAN bus via transceivers (MCP2551 or TJA1040, or etc.).
 * CAN transceivers are not part of NUCLEO boards, therefore must be added by you.
 * Remember also that CAN bus (even a short one) must be terminated with 120 Ohm resitors at both ends.
 *
 * For more details see the wiki page <https://developer.mbed.org/users/hudakz/code/CANnucleo_Hello/>
 *
 * NOTE: If you'd like to use the official NUCLEO boards comment out line 22
 *
 * The same code is used for both NUCLEO boards, but:
 *      For board #1 compile the example without any change.
 *      For board #2 comment out line 23 before compiling
 *
 * Once the binaries have been downloaded to the boards reset board #1.
 *
 */

//#define TARGET_STM32F103C8T6  1     // uncomment this line when using STM32F103C8T6 boards!
//#define BOARD1                1     // comment out this line when compiling for board #2



//CAN devices IDs and reserved ID's-----------------------------------
//ID|Device
//9|ECU|Key switch
//10|ECU|Charge/discharge
//11|BMS1|Cell voltages
//12|BMS2|Cell voltages
//13|BMS3|Cell voltages
//?|Charger|
//
//-------------------------------------------------------------------




/*************Zivan NG3-G7MICB Charger(Input 230VAC-19A;Output 96 VDC-25A)*****
Processo de carregamento:
(1) Desconectar carregador da rede AC
(2) Conectar carregador as baterias
(3) Conectar carregador da rede AC(talves mais pratico ter botao?)
(4) Carga iniciase automaticamente(?) até uma tensao maxima de 4*27=108V
(5) Para desligar carregador desconectar da rede AC      

Tarefas:
-ver celulas em que o balanceamento nao esta a funcionar
-ver porque as tensões nao se estão a actualizar (por a fazer display da soma das tenções)
-ver porque o charger nao responde as mensagens CAN

-acabar de formatar o codigo do BMS encurtando interrupts, programando todas as BMS's e aumentando fiabilidade, etc
-ligar carregador e ver que tensoes de CAN e de saida manda cá para fora+ ver que mensagens

Atenção: 
-obrigatorio conectar e desconectar as baterias do carregador quando este esta desconectado da rede AC
-em caso de algum problema desligar primeiro ficha da redeAC do carregador e depois desconectar ficha das baterias   

Mensagens:
(charger CAN node is 11 by default. So the Id of the message will be 0x60B in
hexadecimal)

Charger->BMS (normally reserved id's)
0x380+node_id (period: 1,000S): actual output current, voltage and Ah
0x280+node_id (period: 4,000S): alarms flags, hardware start/stop status
0x180+node_id (answer for 0x776 message): tambem é uma das respostas durante o precharge
0x580+node_id: answer to 0x600 SDO message

BMS->Charger
0x776: (broadcast; from BMS to chargers): current and voltage setpoints, battery detection setpoint
0x6C1: (broadcast message; from BMS to charger): only mandatory message BMS need to implement (4s timeout)
0x600+node_id: SDO messages

Reserved id's: 
0x48A
0x68A
0x69A
0x777
0x380+node_id
0x180+node_id
0x600+node_id
0x580+node_id
...remote display default node is 21...

Precharge(not used):
(ID|Message)
To charger:(0x600+node_id   |   22-60-60-01-V_HI-V_LO-0-0)
From charger:(0x580+node_id |   60-60-60-01-0-0-0-0)
From charger:(0x580+node_id |   80-60-60-01-XX-XX-XX-XX)
From charger:(0x180+node_id |   I_HI-I_LO-V_HI-V_LO-01-'O'-'K'-n)
To charger:(0x600+node_id   |   22-60-60-02-0-0-0-0)
From charger:(0x580+node_id |   60-60-60-02-0-0-0-0)
From charger:(0x580+node_id |   80-60-60-02-XX-XX-XX-XX)


testar:------------------------------------

-ver se BMS esta realmente a actualizar tensoes comparando tensoes a ser ou nao carregadas

test3:----------------------------
-checkar que o balanceamento de todas as celulas estao a funcionar
-ajustar bms para carga final e amostra da soma total das tensoes

test4:-----------------------------
-carregamento final

test5:-----------------------------
-descarregamento ate metade da tensão p testar aquecimento do balanceamento

******************************************************************************/


const unsigned int RX_ID = 0x100;
const unsigned int TX_ID = 0x101;

#include "CANnucleo.h"
#include "mbed.h"

/*
 * To avaoid name collision with the CAN and CANMessage classes built into the mbed library
 * the CANnucleo's CAN and CANMessage classes have been moved into the CANnucleo namespace.
 * Remember to qualify them with the CANnucleo namespace.
 */
CANnucleo::CAN          can(PA_11, PA_12);  // CAN Rx pin name, CAN Tx pin name
CANnucleo::CANMessage   rxMsg;
CANnucleo::CANMessage   txMsg;
CANnucleo::CANMessage   throttle_txMsg;


DigitalOut              led(PA_5);
DigitalOut              controller_key_switch(PA_6);

Timer                   timer;
volatile bool           msgAvailable = false;
volatile bool           to_send = false;
float cellsv[36]; 
float cellst[96]; 
/**
 * @brief   'CAN receive-complete' interrup handler.
 * @note    Called on arrival of new CAN message.
 *          Keep it as short as possible.
 * @param
 * @retval
 */
void onMsgReceived()
{
    msgAvailable = true;
}

/**
 * @brief   Main
 * @note
 * @param
 * @retval
 */

//bool key_switch = 0;


void refresh()
{
    //key_switch = !key_switch;
    led = controller_key_switch;
    to_send=1;
    //printf("controller switch\r\n");
    // to_send = 1;
}

void cvprint(){
    int n;
    float soma=0;
    for(n=35; n>=0; n--){
        //printf("cellsv0: %f    cvprint\r\n", cellsv[0]);    
        printf("cell: %d   voltage: %f   \r\n", n+1,cellsv[n]);
               
        if(cellsv[n]>=0.1)
        {
        soma=cellsv[n]+soma;
        }
    }
        
        printf("Total battery voltage: %f   \r\n", soma);     
        printf("\r\n""""""""""""""""""""""""""""""""""""""""""""""""\r\n");
    }

void ctprint(){
    int n;
    float temp;
    float current;
    float r;
    
    
    
    for(n=95; n>=0; n--){
      
      
      //mascara:-----------------------------
      if(cellst[n]>125||cellst[n]<-40){
         cellst[n]=273.15*-1;
         //cellst[n]=1;
          }
      
      //-------------------------------------
      
      
    //    temp=cellst[n]/1000;
        
    //    r=(temp*10000)/(3.3-temp);
        
    /*    
        current=(temp/10000);
        r = (3300/current)-10000;
      */
      
     //   temp = 3380/log(r/0.119228);
      //  temp = temp-273.15;
      
        
        //printf("celtemplsv0: %f    cvprint\r\n", cellsv[0]);    
        //printf("ntc: %d   temperature: %f \r\n", n+1,temp);
        printf("ntc: %d   temperature: %f \r\n", n+1,cellst[n]);
    }
    printf("\r\n""""""""""""""""""""""""""""""""""""""""""""""""\r\n");
}


void flip()
{
    controller_key_switch = !controller_key_switch;
    led = controller_key_switch;
}

void ialarm() //desligamento dos contactores devido a IMD
{
    controller_key_switch = 0;
    led = controller_key_switch;
}


Ticker refresher;
Ticker printer;
Ticker printer2;
InterruptIn button(PC_13);

InterruptIn imdok(PA_9);

typedef union can_union {
    int i[2];
    char bytes[8];
    float f[2];
} data;

//bool to_charge_or_not_to_charge=true;           // false = discharge
bool charging = 1;

uint8_t motostate=0;

int main(){
    can.frequency(1000000);                     // set bit rate to 1Mbps
    can.attach(&onMsgReceived);                 // attach 'CAN receive-complete' interrupt handler
    refresher.attach(&refresh, 5);                 // turn on or off
  button.rise(&flip); 
  imdok.fall(&ialarm);    
        printer.attach(&cvprint, 20);                 // turn on o
        printer2.attach(&ctprint, 50);                 // turn on o
        
    //led=key_switch;
    controller_key_switch=0;
    led=controller_key_switch;
    
    timer.start();  // start timer

    printf("started\r\n");
    while(true) {

        if(msgAvailable) {
            data data;
            int len = can.read(rxMsg);
            msgAvailable = false;
            
            if((rxMsg.id==11)||(rxMsg.id==12)||(rxMsg.id==13)){
                data.bytes[0] = rxMsg.data[0];
                data.bytes[1] = rxMsg.data[1];
                data.bytes[2] = rxMsg.data[2];
                data.bytes[3] = rxMsg.data[3];
               // printf(" Id: %d, data: %f, counter : %d\n", rxMsg.id, data.f[0],rxMsg.data[4]);
                cellsv[(rxMsg.id-11)*12+rxMsg.data[4]-1]=data.f[0];
                //printf("cell: %d\r\n", rxMsg.data[4]);
                /*
                printf("\r\nreceived message ID: \t%d\n\r", rxMsg.id);
                for(int i=0; i<len; i++) {
                    printf("\t%x",rxMsg.data[i]);
                }*/
               // printf("\r\n");
               /* if(rxMsg.data[4] == 1) {  //counter == 12
    
                    printf("\r\n""""""""""""""""""""""""""""""""""""""""""""""""\r\n");
                }
                */
                // Filtering performed by software:
            }else if((rxMsg.id==21)||(rxMsg.id==22)||(rxMsg.id==23)){       
           //     cellst[(rxMsg.id-21)*32+rxMsg.data[4]-1]=data.f[0];
             
                data.bytes[0] = rxMsg.data[0];
                data.bytes[1] = rxMsg.data[1];
                data.bytes[2] = rxMsg.data[2];
                data.bytes[3] = rxMsg.data[3];

                    
                cellst[(rxMsg.id-21)*32+rxMsg.data[4]-1]=data.f[0];
                
                //printf("temp: %d   \r\n", rxMsg.data[1]);
            }else if(rxMsg.id==8){
                data.bytes[0] = rxMsg.data[0];
                controller_key_switch=0;
                led=controller_key_switch;
                
                printf("alarm_code: %c ----------------- contactors disconnected\r\n",data.bytes[0]);
                
                }
            
        }
        if(to_send) {
            to_send = 0;
            
            
            //------------------------------------------------
            //ECU to BMS State
            
            //motostate: (0|0|0|0|0|0|to_charge_or_not_to_charge|key_switch)
            txMsg.clear();
            txMsg.id = 9;     //BMS1=>ID:11; BMS2=>ID:12; BMS3=>ID:13.
            txMsg.len = 1;
            motostate = (0b00000001 & controller_key_switch)|((0b00000001 & charging)<<1);
            txMsg.data[0] = motostate;
            //------------------------------------------------            

            if(can.write(txMsg)) {
                printf("sent message\r\n");
            } else {
                static char count = 0; //desta maneira o count é sempre zero e assim nunca chega a 3??
                count++;
                printf("transmission error\n\r overflow: %x\n\r", count);
                if(count == 3) {
                    count = 0;   
                    NVIC_SystemReset();   //faz reset se estiver a falhar o envio de mensagens
                    // attach 'CAN receive-complete' interrupt handler

                }

            }
        }
    }
}



