// Source: eCompass v3

#include "mbed.h"

#ifndef _MAGNETIC_H_
#define _MAGNETIC_H_

typedef int16_t int16;
typedef uint16_t uint16;
typedef int32_t int32;
typedef uint32_t uint32;

#define MAGBUFFSIZE (216)               // magnetic buffer size: 6 implies 6^3 = 216 entries
#define FINVMATRIXSCALING (50.0F)     // inverse of FMATRIXSCALING
#define FUTPERCOUNT (0.1F)            // MAG3110 and FXOS8700 provide 0.1uT per count resolution 
#define FMATRIXSCALING (0.02F)        // approx normalizes geomagnetic field 50uT 
#define MAXMATINV 6                 // maximum size supported in matrix inverse function

// 3d arrays, dude...

struct MagneticBuffer {
    int16 iBx[MAGBUFFSIZE]/*[MAGBUFFSIZE][MAGBUFFSIZE]*/;   // array of x magnetic fields
    int16 iBy[MAGBUFFSIZE]/*[MAGBUFFSIZE][MAGBUFFSIZE]*/;   // array of y magnetic fields
    int16 iBz[MAGBUFFSIZE]/*[MAGBUFFSIZE][MAGBUFFSIZE]*/;   // array of z magnetic fields
    //int32 index[MAGBUFFSIZE][MAGBUFFSIZE][MAGBUFFSIZE]; // array of time indices
    //int32 iMagBufferCount;                              // number of magnetometer readings
};

// magnetic calibration structure
struct MagCalibration
{
    float fVx;                          // x component of computed hard iron offset
    float fVy;                          // y component of computed hard iron offset
    float fVz;                          // z component of computed hard iron offset
    float fB;                           // computed geomagnetic field magnitude in uT 
    float fFitErrorpc;                  // computed fit error %
    float ftrVx;                        // trial value of x component of hard iron offset
    float ftrVy;                        // trial value of y component of hard iron offset
    float ftrVz;                        // trial value of z component of hard iron offset
    float ftrB;                         // trial value of geomagnetic field magnitude in uT 
    float ftrFitErrorpc;                // trial value of fit error %
    int32 iValidMagCal;                 // valid magnetic calibration flag
    float xfinvW[3][3];                 // estimated inverse soft iron matrix size
    float *finvW[3];
    float xfA[3][3];                    // estimated ellipsoid matrix A 
    float *fA[3];
    float xinvA[3][3];                  // inverse of ellipsoid matrix A 
    float *finvA[3];                    
    float xftrinvW[3][3];               // trial computed inverse soft iron matrix size 
    float *ftrinvW[3];              
};

struct vmagi16{
	int16_t x;
	int16_t y;
	int16_t z;
};

struct i16MagCalibration{
	int16_t itrVx;
	int16_t itrVy;
	int16_t itrVz;
};

void fUpdateCalibration4INV(struct MagCalibration *pthisMagCal,
    struct MagneticBuffer *pthisMagneticBuffer,
    float **ftmpA4x4, float **ftmpB4x4, float **ftmpA4x1,
    float **ftmpB4x1, int32 **icolind, int32 **irowind, int32 **ipivot);

void ResetMagCalibration(struct MagCalibration *pthisMagCal/*, struct MagneticBuffer *pthisMagneticBuffer*/);

void magUpdateCalibration(struct MagCalibration *pthisMagCal,
    struct MagneticBuffer *pthisMagneticBuffer);
    
#endif
