/**@file FastAtan2.h
*
* Computes the arctangent using Lagrange polynomial approximation with fixed-point arithmetic.
*
* 
*/
 
#include "mbed.h"

#ifndef FASTATAN2_H_
#define FASTATAN2_H_

#define QFORMAT 15

/******************* Constant Q15 ********************/ 

#define PI_Q15 0x19220 		// Pi 
#define PI2_Q15 0xC910 		// Pi/2 
#define PI4_Q15 0x6488		// Pi/4 
#define PIx2_Q15 0x32440	// 2*Pi 
#define C1 0x1F52 			// constante c1 = 0.2447
#define C2 0x819 			//	constante c2 = 0.0663

/*************** Fixed-point operations ****************/ 

#define FSUBI(a,b,q) ((a)-((b)<<(q)))
#define FMUL(a,b,q) (((a)*(b))>>(q))

/************** Fixed-point conversions ****************/
 
#define TOFIX(d,q) ((int32_t)( (d)*(float)(1<<(q)) ))
#define TOFLT(a,q) ((float)(a)/(float)(1<<(q)))

#define RAD_Q15_TODEG(rad) ((rad*57)+0x25DC)

/** Calculates the arc tangent using fixed point q15
*	@param x Coordinate
* 	@param y Coordinate
*	@returns
*   The function returns the principal arc tangent of y/x, in the interval [0,+pi/2] radians in format Q15
*/

int32_t atan_q15(uint32_t x,uint32_t y);

/** Calculates the arc tangent using fixed point q15
*	@param x Coordinate
*	@param y Coordinate
*	@returns
*   The function returns the principal arc tangent of y/x, with the correct quadrant in the interval [-pi,+pi] radians in format Q15
*/

int32_t atan2_q15(int32_t x,int32_t y);

#endif /* FASTATAN2_H_ */

/**
*
*/