
#include "FastAtan2.h"


int32_t atan_q15(uint32_t x, uint32_t y)
{

    int ang;
    int rdiv;

    if(y>x) {
        rdiv=(x<<QFORMAT)/y;
        ang= PI2_Q15 - FMUL(PI4_Q15,rdiv,QFORMAT)-FMUL(rdiv,FMUL(FSUBI(rdiv,1,QFORMAT),C1+FMUL(C2,rdiv,QFORMAT),QFORMAT),QFORMAT);

    } else {
        rdiv=(y<<QFORMAT)/x;
        ang=FMUL(PI4_Q15,rdiv,QFORMAT)-FMUL(rdiv,FMUL(FSUBI(rdiv,1,QFORMAT),C1+FMUL(C2,rdiv,QFORMAT),QFORMAT),QFORMAT);
    }

    return ang;
}

int32_t atan2_q15(int32_t x, int32_t y)
{

    int ang;

    if((x>0)&&(y>0)) {	//I Quadrant
        ang=atan_q15(x,y);
    } else if((x<0)&&(y>0)) { //II Quadrant
        x=-x;
        ang=PI_Q15-atan_q15(x,y);

    } else if((x<0)&&(y<0)) { //III Quadrant
        x=-x;
        y=-y;
        ang=-(PI_Q15-atan_q15(x,y));

    } else { //IV Quadrant
        y=-y;
        ang=-atan_q15(x,y);
    }

    return ang;
}
