#include "mbed.h"
#include "Serial.h"
#include <string>
#include "DHT/DHT.h"
#include "HC_SR04_Ultrasonic_Library/ultrasonic.h"

AnalogIn analog_value(A0);

DigitalOut led(LED2);

int main()
{
    Serial serial_td1208(PA_0, PA_1);
    DHT dht11(PA_4, DHT11);
    ultrasonic usensor(PA_8, PA_9, 1000, 1);
    
    //for ultrasonic we use D8,D7

    serial_td1208.baud(9600);
    serial_td1208.format();
    //serial_td1208.printf("%s", init);

    int temperature = 0, humidity = 0, distance = 0, lightlevel = 0;
    printf("\nAnalogIn example\n");
    led = 1;
    while(1) {

        if (led == 1)
            led = 0;
        else
            led = 1;
//TODO: each 10 second we send the value of the DHT11
// use %08x
        if (!dht11.readData()) {
            temperature = static_cast<int>(dht11.ReadTemperature(CELCIUS));
            humidity = static_cast<int>(dht11.ReadHumidity());
        }
        
        distance = usensor.getCurrentDistance();

        serial_td1208.printf("AT$SS=%02x%02x%02x%02x\r\n", temperature, humidity, distance, lightlevel);
        usensor.startUpdates();
        wait(10);
        usensor.pauseUpdates();

    }
}
