/*
Code de l'app4 à mettre dans l'un des mbed

Corentin BLANCHARD blac3206
Pierre BLOUET blop2502
*/ 

#include "mbed.h"
#include "rtos.h"

//Interruption permettant de décoder le manchester
InterruptIn button(p5);

//Tache assurant la reception des messages
Thread recevoir;

//Timer fref cet intervalle nous permet par la suite de savoir si le front détecté doit être prit en compte ou pas afin de décoder le manchester;
Timer tintervale;

//Tableau servant à stocker les bits de preambule, de start, du type et de la length.
int table_test[32]={};

//Tableau contenant la charge utile
int table_message[584]={};
//Tableu où on stocke le CRC16 
int table_CRC16_recu[16]={};
//On init un CRC16 de vérification
int CRC16[] ={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

int i,j,go=0;

//Variable globale permettant la réalisation de notre machine à état
int flag =0;

//Temps entre chaque bit reçu permettant le décodage du manchester
float fref=0.01;

//Variable nous servant pour le calcul de la length que l'on va recevoir dans la trame
int longeurMessage=0;

//Tâches et Ticker permettant l'envoie de trames toute les 2 secondes
Ticker sendMsg;
Thread assembler;
Thread envoyer;

//pin de sortie de la trame
DigitalOut pin19(p19);

//Exemples de différents messages que l'on peut placer dans le tableau msgAEnvoyer pour tester différents messages
int dataMsg1[] = {0,0,1,1,0,1,0,1};
int dataMsg2[] = {0,0,1,1,1,1,1,0,1,1,1,0,1,0,1,1};
int dataMsg3[] = {0,0,0,1,1,1,0,1,0,1,1,1,0,0,0,1,0,0,1,1,1,1,1,0,1,1,1,0,1,0,1,1};

//Charge utile à envoyer dans la trame
int msgAEnvoyer[] = {0,0,1,1,1,1,1,0,1,1,1,0,1,0,1,1};

//tableau dynamique permettant de passer entre les différentes tâches
int *buffer=NULL;
//taille de la table à envoyer
int longeurPaquet;


//Voici ici les différents tableaux permettant le remplissage de la trame au fur et à mesure
int tramePreambule[] = {0,1,0,1,0,1,0,1};
int trameStart[] ={0,1,1,1,1,1,1,0};
int trameTypeFlag[] = {0,0,0,0,0,0,0,0};
int trameLength[] = {0,0,0,0,0,0,0,0};
int trameEnd[] = {0,1,1,1,1,1,1,0};


//Fonction réalisée lors des fronts montants
void front_montant() {
    //Si le flage est à 0 on remplit le tableau contenant du prembmule jusqu'à la length seulement si le temps passé depuis la précédente 
    //acquisition est suffisamment elevé afin de n'avoir que les fronts utiles et de décoder le manchester
    if(flag==0&&tintervale.read()>fref*0.8){
        table_test[j]=0;
        j++;
        tintervale.reset();
    //Lorsque le tableau est remplit, on passe le flag à 1 et on reinitialise j
    if(j==32){flag=1;j=0;}  
    }
    
    //Si le flage est à 2 on remplit le tableau contenant la charge utile seulement si le temps passé depuis la précédente 
    //acquisition est suffisamment elevé afin de n'avoir que les fronts utiles et de décoder le manchester
    if(flag==2&&tintervale.read()>fref*0.8){
        table_message[j]=0;
        j++;
        tintervale.reset();
        //Lorsque le tableau est remplit, on passse le flag a 3 et on reinitialise j
        if(j==(longeurMessage-7)*8){flag=3;j=0;}  
    }
    //Si le flage est à 4 on remplit le tableau contenant le CRC16 seulement si le temps passé depuis la précédente 
    //acquisition est suffisamment elevé afin de n'avoir que les fronts utiles et de décoder le manchester
    if(flag==4&&tintervale.read()>fref*0.8){
        table_CRC16_recu[j]=0;
        j++;
        tintervale.reset();
        //Quand le tableau est remplit on passe le flag à 5 et on reinitialise j
        if(j==16){flag=5;j=0;}  
    }
    
   
    
    
}


//Fonction realisée lors des fronts descendants
void front_d() {
    //Si le flage est à 0 on remplit le tableau contenant du prembmule jusqu'à la length seulement si le temps passé depuis la précédente 
    //acquisition est suffisamment elevé afin de n'avoir que les fronts utiles et de décoder le manchester
    if(flag==0&&tintervale.read()>fref*0.8){
        table_test[j]=1;
        j++;
        tintervale.reset();
    //Lorsque le tableau est remplit, on passe le flag à 1 et on reinitialise j   
    if(j==32){flag=1;j=0;}
    }
    //Si le flage est à 2 on remplit le tableau contenant la charge utile seulement si le temps passé depuis la précédente 
    //acquisition est suffisamment elevé afin de n'avoir que les fronts utiles et de décoder le manchester
    if(flag==2&&tintervale.read()>fref*0.8){
        table_message[j]=1;
        j++;
        tintervale.reset();
        //Lorsque le tableau est remplit, on passse le flag a 3 et on reinitialise j
        if(j==(longeurMessage-7)*8){flag=3;j=0;}  
    }
    //Si le flage est à 4 on remplit le tableau contenant le CRC16 seulement si le temps passé depuis la précédente 
    //acquisition est suffisamment elevé afin de n'avoir que les fronts utiles et de décoder le manchester
    if(flag==4&&tintervale.read()>fref*0.8){
        table_CRC16_recu[j]=1;
        j++;
        tintervale.reset();
        //Quand le tableau est remplit on passe le flag à 5 et on reinitialise j
        if(j==16){flag=5;j=0;}    
}
}


//Tache permettant la reception et le traitement du message
void recevoir_message(){
    while(1){
        //On start le timer pour la recpetion des bits
        tintervale.start();
        //Lorsque le flag est à 0 on attend 
        if(flag==0){
            Thread::wait(1);
        }
        
        //Ici on vérifie qu'on a bien l'octet de start puis on calcule la length
        if(flag==1){
            // on verifie qu'on a bien l'octets de start 
            int octetsStart = 0;
            longeurMessage=0;
            if(table_test[8]==0){octetsStart++;}
            for(int k=9;k<15;k++){
                    if(table_test[k]==1){octetsStart++;}
                }
            if(table_test[8]==0){octetsStart++;}
            if(octetsStart==8){
            //ici le Start est valide 
            // on récupère la longeur du paquet 
               for(int i =24;i<32;i++){
                 int a=1;
                //met a la puissance afin de passer de binaire à int
                 for(int j=0;j<31-i;j++){a = a*2;}
                longeurMessage+=table_test[i]*a;
               }
               //La longueur est trouvée, on passe a l'étape suivante en mettant le flag à 2
               flag =2;
              }
            // start non valide on recommence du début 
            if(octetsStart!=8){ Thread::wait(500);flag=0;} 
            }
            
        //Quand le flag est a 3, on vérifie le CRC afin de savoir si oui ou non on peut print la charge utile    
        if(flag==3){
             
        // on calcul le crc du message recu
            int longueurData = (longeurMessage-7)*8;
            int *data_p = table_message;
    
            unsigned short crc = 0xFFFF;
            unsigned char x;

            while (longueurData--){
                x = crc >> 8 ^ *data_p++;
                x ^= x>>4;
                crc = (crc << 8) ^ ((unsigned short)(x << 12)) ^ ((unsigned short)(x <<5)) ^ ((unsigned short)x);
             }
        
            // convertit le crc en binaire 
            go =15;
                while(go>0){
            CRC16[go]=crc%2;
            crc/=2;
            go=go-1;
         }

            CRC16[go]=crc%2;
            flag = 4;
        }
            
        // on compare les crc afin de voir si le message est bon
        int crc_valid=0;
        if(flag==5){
                for(int i =0;i<16;i++){
                    if(CRC16[i]==table_CRC16_recu[i]){crc_valid++;}
                }
                //Si ce sont les memes on passe a la suite
                if(crc_valid==16){flag=6;}
                //Sinon on recommence depuis le début et on print l'erreur
                if(crc_valid!=16){printf(" error CRC \n\r");Thread::wait(500);flag=0;}
             }
             
        
        //C'est la dernière etape de notre machine a etat dans laquelle on print notre message recu dans la console     
        if(flag==6){
             Thread::wait(500);
             printf("\n\r");
             printf("     message recu : ");
             for(int i=0;i<(longeurMessage-7)*8;i++){
             printf("%d",table_message[i]);
             }
             printf(" \n\r");
             flag = 0;
             }         
        Thread::wait(0.1);
    }
    }

//Fonction qui sera appeler toute les 2 secondes par un Ticker 
//Elle envoie un signal afin de lancer le thread d'assemblage
void createRandomData(void){
    assembler.signal_set(0x1);
    }


        
//Tache d'assemblage de la trame à envoyer       
void assembler_trame(){
    while(1){
        //On attend le signal de départ du Ticker
        Thread::signal_wait(0x1);
        
        int i =7;
        //Calcul du nombre de bits que va contenir notre message et creation du tableau qui va avec
        int msg[7*8+sizeof(msgAEnvoyer)/sizeof(int)]={};
        //Calcul du nombre de bits de notre message en manchester et creation du tableau qui va avec
        int tableMunch[2*sizeof(msg)/sizeof(int)]={};

    // longeur totale de la trame en octets
    int length = 7+sizeof(msgAEnvoyer)/(sizeof(int)*8);
    //longueur totale de la charge utile en bit
    int lengthBits = sizeof(msgAEnvoyer)/sizeof(int);
    // convertit la longeur en binaire pour le mettre sous le format d'envoie de la trame  
    while(i>0){
       trameLength[i]=length%2;
       length/=2;
       i=i-1;
    }
    trameLength[i]=length%2;
    
    // Calcul du CRC
    int longueurData = sizeof(msgAEnvoyer)/sizeof(int);
    int *data_p = msgAEnvoyer;
    int CRC16[] ={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    
    //On peut enlever le calcul à partir d'ici pour avoir un crc erroné en laissant le tableau remplit de 0
    unsigned short crc = 0xFFFF;
    unsigned char x;

    while (longueurData--){
        x = crc >> 8 ^ *data_p++;
        x ^= x>>4;
        crc = (crc << 8) ^ ((unsigned short)(x << 12)) ^ ((unsigned short)(x <<5)) ^ ((unsigned short)x);
        }
        
     // convertit le crc en binaire afin de le mettre dans le tableau correspondant
      i =15;
        while(i>0){
       CRC16[i]=crc%2;
       crc/=2;
       i=i-1;
    }
    CRC16[i]=crc%2;
    
     
     
        // ajoute trame préambule 
    for(int i =0;i<sizeof(tramePreambule)/sizeof(int);i++){
        msg[i]=tramePreambule[i];
        }
        
        // ajoute trame start
    for(int i =8;i<8+sizeof(trameStart)/sizeof(int);i++){
        msg[i]=trameStart[i-8];
        }
        
        // ajoute trame flag
    for(int i =16;i<16+sizeof(trameTypeFlag)/sizeof(int);i++){
        msg[i]=trameTypeFlag[i-16];
        }
        
         // ajoute trame longeur
    for(int i =24;i<24+sizeof(trameLength)/sizeof(int);i++){
        msg[i]=trameLength[i-24];
        }


        // ajoute le message utile 
    for(int i =32;i<32+sizeof(msgAEnvoyer)/sizeof(int);i++){
        msg[i]=msgAEnvoyer[i-32];
     }

        // ajoute CRC a la trame 
    for(int i =32+lengthBits;i<32+lengthBits+sizeof(CRC16)/sizeof(int);i++){
       msg[i]=CRC16[i-32-lengthBits];
    }
        
        // ajoute trame end 
    for(int i =48+lengthBits;i<48+lengthBits+sizeof(trameEnd)/sizeof(int);i++){
        msg[i]=trameEnd[i-48-lengthBits];
        }
 
        // convertie le message a envoyer en manchester et le stock dans le tableau tableMunch
    for(int i =0;i<sizeof(msg)/sizeof(int);++i){
        if (msg[i] == 0){
            tableMunch[i*2] = 0;
            tableMunch[i*2+1]= 1;
            }
        if (msg[i] == 1){
            tableMunch[i*2] = 1;
            tableMunch[i*2+1]= 0;
            }
            }
        //Calcul de la longueur du tableau      
    longeurPaquet = sizeof(tableMunch)/sizeof(int);
    
    //Cette boucle for est ici pour le débugage
    for(int i =0;i<sizeof(tableMunch)/sizeof(int);i++){
      //  printf("%d",tableMunch[i]);
        }
     
    //On recupere la table à envoyer dans le tableau dynamique 
    buffer = tableMunch;
    
    //donne l'ordre d'envoyer le message 
    envoyer.signal_set(0x2);
    }              
    }

//Tache permettant d'envoyer le message dans la pin 19   
void envoyer_message(){
    while(1){
        //Attente de la creation d'une trame avant de l'envoyer
    Thread::signal_wait(0x2);
    //Envoie de la table
    for(int i =0;i<longeurPaquet;i++){
        pin19 = *(buffer+i);
        Thread::wait(1);
        } 
    }
    }    
    
int main() {
    //Detection des fronts descendants
    button.fall(&front_d);
    //Detection des fronts montants
    button.rise(&front_montant);
    //Demarrer la tache de reception
    recevoir.start(recevoir_message);
    //Toute les 2 secondes on va envoyer un message
    sendMsg.attach(&createRandomData, 2.0);
    // assemble la trame : 
    assembler.start(assembler_trame);
    //Envoie la trame
    envoyer.start(envoyer_message);
    //Priorite a la reception pour favoriser le full duplex
    recevoir.set_priority(osPriorityAboveNormal);  
    while(1) {
    //printf("   state : %d   ",flag);
    }
}

