#include "mbed.h"

Serial pc(USBTX, USBRX);   
Serial SIM(p13, p14); 

DigitalOut myled(LED1);
void GSMSetUp(void);

int main() 
{
    int i = 0;
    int CRCounter = 0;
    int IncomingCounter = 0;
    int NewMessage = 0;
    char IncomingChar = 0;
    char IncomingString1 [200] = {};
    char Number [200] = {};
    char Date [200] = {};
    char Message [200] = {};
    
    SIM.baud(115200);
    pc.baud (115200);
    while(1) 
    {
        if(SIM.readable() )                                     //if incoming char from Sim card     
        {
            IncomingChar = SIM.getc();                          //collect the char
            IncomingString1[IncomingCounter] = IncomingChar;    //store char in an array 
        //    pc.putc(IncomingString1[IncomingCounter] );         //print char to screen, goo for debug
            IncomingCounter ++;                                 //increment the char counter
  
            if(IncomingChar == 0x0D)                            //if a carrage return has been detected, then count then up 
            {
                CRCounter++;                                    //increment CR counter 
            
                if(CRCounter == 3)                              //after 3rd CR, the message has ended 
                {
                    pc.printf("\n\r message buffer: %s",IncomingString1);         //print the whole buffer to screen - debug 
                    
                     
                   for(i = 9; i<22 ; i++)                      //parse the array - always has this number/date format 
                    {
                        Number[i-9] = IncomingString1[i];
                    } 
                    
                    Number[13] = NULL;
                    pc.printf("\n\r%s",Number);
                   
                    for(i = 28; i<45; i++)                      //parse data 
                    {
                        Date[i-28] = IncomingString1[i];
                    }
                    
                    pc.printf("\n\r%s",Date);             
                    Date[i-28] = NULL;
                    
             
                    
                    for(i = 51; i<IncomingCounter; i++)       //parse the message
                    {
                        Message[i-51] = IncomingString1[i];
                    }
                    Message[i-52] = NULL;
                    pc.printf("\n\r%s",Message);
                 
                 
                    IncomingChar = SIM.getc();     
                    NewMessage = 1;                             //rasie flag that a new message has been recieved
                    CRCounter = 0;                              //end of message processing, reset all counters etc
                    IncomingCounter = 0;
                    i = 0;                
                }//if CR
            }//if incoming
        }//if sim
        
        if(NewMessage == 1)
        {
            if((!(strcmp(Number,"+447568396622"))) || (!(strcmp(Number,"+447447293026"))))
            {
                pc.printf("\n\right number");
            }
            else
            {
                pc.printf("\n\rUnknown Number");
            }
            
            if(!(strcmp(Message,"Open")))
            {
                pc.printf("\n\rOpening");
            }
            else if(!(strcmp(Message,"Close")))
            {
                pc.printf("\n\rClosing");
            }
            else if(!(strcmp(Message,"Report")))
            {
                pc.printf("\n\rReporting");
            }
            else if(!(strcmp(Message,"OK")))
            {
                pc.printf("\n\rOKing");
            }
            else
            {
                pc.printf("\n\rUnknown Command");
            }
                
            NewMessage = 0;
        }//if NewMessage
            

        if(pc.readable())
        {
          // SIM.putc(pc.getc());
            switch(pc.getc())
            {
                case 'a':SIM.printf("AT+CMGF=1\r\n");  break;
                case 'b':SIM.printf("AT+CSCS=\"GSM\"\r\n"); break;
                case 'c':SIM.printf("AT+CMGS=\"+447568396622\"\r\n"); break;
                case 'd':SIM.printf("WHATS UP MF?"); break;
                case 'e':SIM.putc((char)26); break;
                case 'f':SIM.printf("AT+CNMI=1,2,0,0,0\r\n"); break;   
                case 'g':SIM.printf("AT+CMGL \"REC UNREAD\" 0\r\n"); break;
           }//switch
        }//if
        
    }//while1

}//main
