#include "mbed.h"
#include "math.h"

#define PWMPRESCALE (250-1) 

#define Cool 1
#define Heat 2

Serial pc                             (USBTX, USBRX); 
InterruptIn    EnableButton           (p5);
DigitalOut     EnabledLED                 (LED1);
//DigitalOut  RightLED                (LED2);

DigitalOut  RightPistonShutDownA      (p16);      //red ...shutsdown the right driver
DigitalOut  RightPistonShutDownB      (p17);      //yellow...shutsdown the left driver

DigitalOut  LeftPistonShutDownA       (p14);      //white.... shutsdown the right driver
DigitalOut  LeftPistonShutDownB       (p15);      //blue... shutsdown the left driver



AnalogIn    DutyIn                      (p20);      //pot for duty selection 
AnalogIn    RightPistonPosition         (p18);      //position sensor for the pistons 
AnalogIn    LeftPistonPosition          (p19);


void initPWM(void);                         //pwm initilisation 
void initTimer0(void);
void updatePulseWidth(unsigned int, int);
void EnablePWM(unsigned char);
void DisablePWM(unsigned char);
void StateChange(void);

int LeftState = Heat;  
int RightState = Heat; 
int Enable = 0;
int pulseWidth = 3; 



int main() 
{
    EnableButton.fall(&StateChange);                                     // attach the address of the flip function to the rising edge
    initPWM();  
    RightPistonShutDownA = 0;                   //Disable drivers 
    RightPistonShutDownB = 0; 
    LeftPistonShutDownA  = 0;
    LeftPistonShutDownB  = 0;

    while(1)
    {

                  

        if(Enable == 1)
        {
            RightPistonShutDownA = 1;                   //Enable drivers 
            RightPistonShutDownB = 1; 
            LeftPistonShutDownA  = 1;
            LeftPistonShutDownB  = 1;
            
            EnablePWM(1);                               //Enable PWM channels 
            EnablePWM(2);
            EnablePWM(3);
            EnablePWM(4);
 
            while(Enable == 1)
            {
                
                                //state setting based on sensors 
                if((LeftPistonPosition.read() > 0.68) && (LeftState == Heat) )           //left is heating and has expanded past threshold  
                {
                    LeftState = Cool;                                                    //set left cooling 
                }
                
                if((LeftPistonPosition.read() < 0.60) && (LeftState == Cool) )         //left is cooling and has contracted past the threshold      
                {
                   LeftState = Heat;                                                    //set left heating
                }
                    
                if((RightPistonPosition.read() > 0.68) && (RightState == Heat) )         //left is heating and has expanded past threshold  
                {
                    RightState = Cool;                                                   //set left cooling 
                }
                if((RightPistonPosition.read() < 0.6) && (RightState == Cool) )       //left is cooling and has contracted past the threshold      
                {
                    RightState = Heat;                                                   //set left heating
                }    
                
                
                
                pulseWidth = 1 + (98 * DutyIn.read());      //get duty cycle from analogue in
                //pc.printf("%d\n\r",pulseWidth);
                pc.printf("left  = %.3f\n\r",LeftPistonPosition.read());
                pc.printf("right = %.3f\n\r",RightPistonPosition.read());
                wait(1);
                switch (LeftState)                          //state machine for left piston 
                {
                    case Heat:   
                        LPC_PWM1->MR1 = 99;                 //update the match compare 
                        LPC_PWM1->MR2 = pulseWidth;                            //state - heat 
                        pc.printf("left heating\n\r");
                    break;
                    
                    case Cool:                              //state cool 
                        LPC_PWM1->MR1 = pulseWidth;         //update left with analogue value 
                        LPC_PWM1->MR2 = 99;                 //keep right driver with 99% on. dont do 100% as boot strap needs servicing 
                        pc.printf("left cooling\n\r");
                    break;
                }
                    
               
 

                
                switch (RightState)                         //state machine for right piston  
                {
                    case Heat: 
                        LPC_PWM1->MR3 = pulseWidth;         //update left with analogue value 
                        LPC_PWM1->MR4 = 99;                 //keep right driver with 99% on. dont do 100% as boot strap needs servicing 
                        pc.printf("right heating\n\r");
                    break;
                    
                    case Cool:          
                        LPC_PWM1->MR3 = 99;
                        LPC_PWM1->MR4 = pulseWidth;
                        pc.printf("right cooling\n\r"); 
                    break;
                }
                LPC_PWM1->LER = (1<<1)| (1<<2)| (1<<3)| (1<<4);  //LATCH ENABLE REG - enable new values for in MR0 and MR1                 
            }
        }
        else
        {
            pc.printf("left  = %.3f, right = %.3f\r",LeftPistonPosition.read(), RightPistonPosition.read() );
       //     pc.printf("\n\r",);
            wait(1);
            LeftPistonShutDownA   = 0;          //Disable drivers 
            LeftPistonShutDownB   = 0; 
            RightPistonShutDownA  = 0;                  
            RightPistonShutDownB  = 0;    
            
       //     DisablePWM(1);                      //Diable PWM on uC
        //    DisablePWM(2);
        //    DisablePWM(3);
         //   DisablePWM(4);
        }    
    }
}
 
 
 
void StateChange (void)
{
    __disable_irq();
    wait(0.3);
    
    if(Enable == 1)
    {
        Enable = 0;
        EnabledLED = 0;
        pc.printf("Disabled\n\r");
        
    }
    else
    {
        Enable = 1;
        EnabledLED = 1;
        pc.printf("Enabled\n\r");
    }
    wait(2); 
    __enable_irq();
}


void initPWM(void)
{
    LPC_PINCON->PINSEL4 = (1<<0)|(1<<2)|(1<<4)|(1<<6);          //set up the pins to be PWM outputs  '01 01 01 01' is pwm mode put onto Mbed pins 26,25,24,23.      
    
    LPC_PWM1->PR = PWMPRESCALE;                                 //1 micro-second resolution (24 ticks to pclk)
    LPC_PWM1->MR0 = 100;                                        //20 ticks to match = 20uS period  
    LPC_PWM1->MR1 = 10;                                         //1us - default pulse duration i.e. width. changed by analgo in 
    LPC_PWM1->MR2 = 10;                                         //match comapre registers for the 4 PWM channels 
    LPC_PWM1->MR3 = 10;                      
    LPC_PWM1->MR4 = 10;
    
    LPC_PWM1->MCR = (1<<1);                                   //Reset PWM timer counter on PWM1_MR0 match : match control register 
    LPC_PWM1->LER = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4);          //update values in MR0 and MR1: latch enabe register 
    LPC_PWM1->TCR = (1<<1);                                     //Reset PWM timer counter & prescale counter : timer control register 
    LPC_PWM1->TCR = (1<<0) | (1<<3);                     //Enable counters and enter PWM Mode, **PWM Generation goes active now**
    
   // LPC_PWM1->PCR |= (1<<9)|(1<<10)|(1<<11)|(1<<12);         //enable PWM channel 1 to 4. 
    

}






void EnablePWM(unsigned char PWMChannel)
{
  
    switch(PWMChannel)
    {
        case 1: LPC_PWM1->PCR |= (1<<9);  break;        //enable PWM channel 1 to 4. 
        case 2: LPC_PWM1->PCR |= (1<<10); break;
        case 3: LPC_PWM1->PCR |= (1<<11); break;
        case 4: LPC_PWM1->PCR |= (1<<12); break; 
    }
}



void DisablePWM(unsigned char PWMChannel)
{
    
    LPC_PWM1->TCR = (0<<0) & (0<<3);                    //Disable counters and enter timer Mode, 
    switch(PWMChannel)
    {
        case 1: LPC_PWM1->PCR &= (0<<9);  break;        //PCT is pulse width control register- enables PWM channels 
        case 2: LPC_PWM1->PCR &= (0<<10); break;        //bits 9,10,11 and 12 enable PWM 1,2,3,4.
        case 3: LPC_PWM1->PCR &= (0<<11); break;        //clear all of these bits 
        case 4: LPC_PWM1->PCR &= (0<<12); break;
    }
}









/*void initTimer0(void) //To setup Timer0 used delayMS() function
{
    LPC_TIM0->CTCR = 0x0;
    LPC_TIM0->PR = 25-1; //Increment TC at every 24999+1 clock cycles //25000 clock cycles @25Mhz = 1 mS (1us is 25)
    LPC_TIM0->TCR = 0x02; //Reset Timer
}
*/






