#include "mbed.h"
                                                          
Serial pc(USBTX, USBRX);                    //Create serial object for serial comms

DigitalOut  myled               (LED1);
DigitalOut  StoppedLED          (LED4);

DigitalOut  PinOut              (p7);       //serial data link for 1 motor

AnalogIn    Open_Signal         (p18);      //0 normal, 3 volts signal
AnalogIn    Close_Signal        (p19);      //2.6 nomal, 0 volt signal 

DigitalIn   CloseLimit_Signal   (p14);      //inputs from the user relays
DigitalIn   OpenLimit_Signal    (p15);
DigitalIn   Stop_Signal         (p16);  
DigitalIn   TorqueOff           (p17);      //used for torque off and limit setting 
AnalogIn    PotInput            (p20);      //pot used to set speed 



void SelectDirection    (void);                  //funtion prototypes
void SetOpen            (void);
void SetClose           (void);
void Transmit           (void);

                                            //global variables 
unsigned char GlobalDirectionChanged = 0;   //flag for direction of motor  
unsigned int SendByte;                      //32 bit, used to select immdiate 9 bit char to send
unsigned int ByteStream [10] = {85, 70, 70, 34, 0, 256, 140, 1, 140,1}; //byte stream to send. last 4 bytes get modified according to pot and direction 
int delay = 18;                             //global defining the delay constant, 30uS 
                                                                //enum defines 
enum Directions {Opening, Closing};                             //define the directions of movement  
enum States {Idle, Stop, Open, Close, OpenLimit, CloseLimit};   //define the states
enum States state = Stop;                                       //set up initial state 
enum Directions Direction = Opening;                            //set up initial direction 


int main(void)
{
    float OpenSig = 0;
    float CloseSig = 0;
    float Input = 0;                //input from ADC
    unsigned int Major = 0;         //major speed value - eleements 5 and 7 
    unsigned int Minor = 0;         //minor speed values - elements 4 and 6
    unsigned char DirectionChanged = 0;    // 0 = open, 1 = close
    int i = 0;
    pc.baud(115200);
    
  
    PinOut = 1;      
    
    ByteStream [6] = 41;        // stop signal detected, send zeros ... send 170 instead of 85 maybe??
    ByteStream [7] = 0;         // send 0x41 as it has lots of 1s and 0s. keeps the comms link alive
    ByteStream [8] = 41;
    ByteStream [9] = 0;
    
    for(i = 0;i<1000;i++)
    {
        Transmit();
    
    }
    
    
    while(1)
    {
            
            
            for(i = 0;i<15;i++)
            {
                OpenSig = (OpenSig + Open_Signal.read() ) ;
                CloseSig = (CloseSig + Close_Signal.read() ) ;    
            }
            
            pc.printf("close = %f, open = %f \n\r",CloseSig, OpenSig); 
            if(OpenSig < 1)                  //if the open signal detected then set open 
            SetOpen();
            
            if(CloseSig < 1)                    //if the close signal detected then close 
            SetClose();
       
       
       
            OpenSig = 0;
            CloseSig = 0;
  
  
  
            Input = 100+(PotInput.read() * 1000);     //read analog in, convert to between [0->1000]
            Input = Input / 166;                //250..divide by 6 to get major sections between [0.xx -> 6.xxx]
            Major = floor(Input);               //round down to give integer [1 -> 4]
            Minor = (Input - Major) * 250;      //250..get minor from remainder 0.xx and times by 250. [0 -> 250]  
 
            switch (state) 
            {
                case Stop:                      //main stop state                   
                    //pc.printf("STATE: STOP \n\r");
                    ByteStream [6] = 41;        // stop signal detected, send zeros ... send 170 instead of 85 maybe??
                    ByteStream [7] = 0;         // send 0x41 as it has lots of 1s and 0s. keeps the comms link alive
                    ByteStream [8] = 41;
                    ByteStream [9] = 0;
                    DirectionChanged = GlobalDirectionChanged;  //update local variable from global. needed because modified by interrupt  
                    if(DirectionChanged == 1)                   //ignore any direction commands when in stop mode
                    {
                        DirectionChanged = 0;                   //reset the flags
                        GlobalDirectionChanged = 0;
                    }
                    
                    if(Stop_Signal == 1)        //in a stopped state. stay here until 'local' is seen
                        state = Stop;
                    else
                        state = Idle;           //stop signal is off, go to idle mode.
                break;
                
                
                case Idle:                      // idle mode, stays still until  a direction is seen
                   // pc.printf("STATE: idle \n\r");
                    ByteStream [6] = 41;         // stop signal detected, send zeros ... send 170 instead of 85 maybe??
                    ByteStream [7] = 0;
                    ByteStream [8] = 41;
                    ByteStream [9] = 0;
                    DirectionChanged = GlobalDirectionChanged;  //update local flag                                                     
                    
                    if(DirectionChanged == 1)                   // a direction input has been detected  
                    {
                        DirectionChanged = 0;                   //acknowledge the detection has been seen
                        GlobalDirectionChanged = 0;
                        if(Direction == Opening)              //check the current direction. set during direction interrupt 
                       {
                            state = Open;                       //      
                        }
                        else if(Direction == Closing)
                        {
                            state = Close;              
                        }
                    }

                    if(OpenLimit_Signal == 1)               //open limit detected.
                        state = OpenLimit;
                        
                    if(CloseLimit_Signal == 1)               //open limit detected.
                        state = CloseLimit;
                        
                    if(Stop_Signal == 1)                    //stop signal detected. 
                        state = Stop;
                break;
                
                
              
                case Open:
                    //pc.printf("STATE: Opening \n\r");
                    ByteStream [6] = Minor;         // in one direction, the values are as is major = {0,1,2,3,4} minor = {0 to 250} 
                    ByteStream [7] = Major;
                    ByteStream [8] = Minor;
                    ByteStream [9] = Major;      
                    DirectionChanged = GlobalDirectionChanged;
                    
                    if(DirectionChanged == 1)           // a direction input has been detected  
                    {
                       DirectionChanged = 0;           //acknowledge the servicing
                        GlobalDirectionChanged = 0; 
                        if(Direction == Opening)              //check the direction 
                        {
                            state = Open;                
                        }
                        else
                        {
                           state = Close;              
                        }
                    }
                    
                   if(OpenLimit_Signal == 1)        //in a stopped state. stay here until 'local' is seen
                   {
                        state = OpenLimit;
                    }
                     
                  if(Stop_Signal == 1)        //in a stopped state. stay here until 'local' is seen
                  {
                        state = Stop;
                  }
                break; 
                        
                        
                case Close:
                   // pc.printf("STATE:  Closing \n\r");
                    ByteStream [6] = (255 - Minor); // in the other direction, the values are complementry      
                    ByteStream [7] = (255 - Major); // major = {256,255,254,253} and minor = {250 to 0}
                    ByteStream [8] = (255 - Minor);
                    ByteStream [9] = (255 - Major);

                    DirectionChanged = GlobalDirectionChanged;
                    if(DirectionChanged == 1)           // a direction input has been detected  
                    {
                        DirectionChanged = 0;           //acknowledge the servicing
                        GlobalDirectionChanged = 0;
                        if(Direction == Opening)              //check the direction 
                        {
                            state = Open;                
                        }
                        else
                        {
                            state = Close;              
                        }
                    }

                    if(CloseLimit_Signal == 1)        //in a stopped state. stay here until 'local' is seen
                    {
                        state = CloseLimit;
                    }
                    
                    if(Stop_Signal == 1)        //in a stopped state. stay here until 'local' is seen
                     {
                        state = Stop;
                    }
                break;
    
                
                case OpenLimit:  
                   // pc.printf("STATE: Open Limit \n\r");
                    ByteStream [6] = 41;         // stop signal detected, send zeros ... send 170 instead of 85 maybe??
                    ByteStream [7] = 0;
                    ByteStream [8] = 41;
                    ByteStream [9] = 0;
                    DirectionChanged = GlobalDirectionChanged;
                    if(DirectionChanged == 1)           // a direction input has been detected  
                    {
                        DirectionChanged = 0;           //acknowledge the servicing
                        GlobalDirectionChanged = 0;
                        if(Direction == Opening)              //check the direction 
                        {
                            state = OpenLimit;                
                        }
                        else
                        {
                            state = Close;              
                        }

                        if(Stop_Signal == 1)        //in a stopped state. stay here until 'local' is seen
                        {
                            state = Stop;
                        }
                    }
                break;
                
                
               case CloseLimit: 
                   // pc.printf("STATE: Close Limit \n\r"); 
                    ByteStream [6] = 41;         // stop signal detected, send zeros ... send 170 instead of 85 maybe??
                    ByteStream [7] = 0;
                    ByteStream [8] = 41;
                    ByteStream [9] = 0;
                    DirectionChanged = GlobalDirectionChanged;
                    if(DirectionChanged == 1)           // a direction input has been detected  
                    {
                        DirectionChanged = 0;           //acknowledge the servicing
                        GlobalDirectionChanged = 0; 
                   
                        if(Direction == Opening)              //check the direction 
                        {
                            state = Open;                
                        }
                        else
                        {
                            state = CloseLimit;              
                        }
                        
                        if(CloseLimit_Signal == 0)
                        {
                            state = Idle;
                        } 
                        
                        if(Stop_Signal == 1)        //in a stopped state. stay here until 'local' is seen
                        {
                            state = Stop;
                        }
                    }
                break;
                

                default: 
                 //   pc.printf("problems \n\r");
                    StoppedLED = 0;  
                    ByteStream [6] = 41;         // stop signal detected, send zeros ... send 170 instead of 85 maybe??
                    ByteStream [7] = 0;
                    ByteStream [8] = 41;
                    ByteStream [9] = 0;
                break;
            } 
        Transmit(); // the state machine has modified the bytestream according to signals. send to motor
        
    }   
}



void Transmit(void)
{
    unsigned int BitCounter = 0;    //counts 9 bits when bit banging
    unsigned char ByteCounter = 0;  //counts the 8 9bit-bytes to bang per frame     
    unsigned int Mask  = 1;         //mask use for bit banging
    
    for (ByteCounter = 0; ByteCounter <10;ByteCounter++)
        {
            wait_us(35);           //wait 75uS between each characte, emperically merasured using logic 26300 baud
            Mask = 0x001;           //reset mask    
            PinOut = 0;             //start bit, clear the data line
            wait_us(delay-1);       //wait 32uS
             
             for(BitCounter = 0; BitCounter < 9 ; BitCounter ++) // counter starts at 1 0000 0000 (256) and bit bangs to zero 
             {
                if(Mask & ByteStream[ByteCounter]) //bang the byte 
                {
                    PinOut = 1;
                }
                else
                {
                     PinOut = 0;
                }
                wait_us(delay-1);       //wait, remove a cople uS to allow for the time instructions took to execute 
                Mask = (Mask <<= 1);    //shift mask
            }
            PinOut = 1;                 //stop bit,
            wait_us (delay);                
        }
}



void SetOpen (void)
{
            GlobalDirectionChanged = 1;
            Direction = Opening;
      //      pc.printf("\n\rO");

}



void SetClose (void)
{
        GlobalDirectionChanged = 1;
        Direction = Closing;
       // pc.printf("\n\rC"); 
}

      



