#ifndef __gps_utils_h__
#define __gps_utils_h__

#include <math.h>

#ifndef M_PI
    #define M_PI 3.14159265358979323846
#endif

#define TWO_PI (M_PI+M_PI)

#define EARTH_RADIUS_METERS 6371000

//Functions extracted from http://movable-type.co.uk/scripts/latlong.html

//
// Calculate the distance between two points on earth using the haversine function.
// Most accurate and expensive distance calculating function in this library.
// lat and lon values expected in radians.
// Returns distance in meters
//
double haversine(double lat1, double lon1, double lat2, double lon2);

//
// Calculate the distance between two points on earth using the spherical law of cosines.
// Less expencive than haversine, but not good at small distances.
// lat and lon values expected in radians.
// Returns distance in meters
//
double cosines(double lat1, double lon1, double lat2, double lon2);

//
// Calculate the distance between two points on earth using equirectangular approximation.
// Least accurate and expensive distance calculating function, suitable only for small distances.
// lat and lon values expected in radians.
// Returns distance in meters
//
double equirectangular(double lat1, double lon1, double lat2, double lon2);

//
// Calculates the inital bearing a journey requires if traveling from lat1,lon1 to lat2,lon2.
// (Bearing can naturally change as one travels along the sphere)
// lat and lon values expected in radians.
// Returns bearing in the range 0-2*PI
//
double startBearing(double lat1, double lon1, double lat2, double lon2);

//
// Calculates the bearing a journey will end on if traveling from lat1,lon1 to lat2,lon2.
// (Bearing can naturally change as one travels along the sphere)
// lat and lon values expected in radians.
// Returns bearing in the range 0-2*PI
//
double endBearing(double lat1, double lon1, double lat2, double lon2);

#endif //__gps_utils_h__