//#include "mbed.h"
//#include <algorithm>
//#include "asyncADC.h"
//#include "arm_math.h"
//#include "arm_common_tables.h"
//#include "moppy.h"
//#include "Terminal.h"
//
//#define AUDIO_PIN       (A0)
// 
//Terminal pc(USBTX, USBRX, 115200);
//DigitalOut process_led(LED3); // Blue
//Timer timer;
//
//#define FFT_SIZE 2048
//#define SAMPLE_RATE_HZ  10000    // Sample rate in Hertz
//#include "fft.h"
//
//#define BIN_TO_FREQ(bin)  ((bin*(long)SAMPLE_RATE_HZ)/FFT_SIZE)
//
//
//#define FREQ_ANALYSER_SCALAR    (3)
//#define FREQ_ANALYSER_WIDTH     (FFT_SIZE>>(FREQ_ANALYSER_SCALAR+1))
//#define FREQ_ANALYSER_HEIGHT    (10)
//
////BUFFERS
//
//uint16_t adcBuffer[FFT_SIZE*2];
//float fftBuffer[FFT_SIZE*2];
//float magnitudes[FFT_SIZE];
//char pcBuffer1[FREQ_ANALYSER_WIDTH+3];
//char pcBuffer2[FREQ_ANALYSER_WIDTH+3];
//
//
//// INTERRUPTS
//
//volatile int sectionCounter = 0;
//volatile bool sectionFilled = false;
//volatile uint32_t sectionStart, sectionEnd;
//
//void callback(uint32_t start, uint32_t end) {
//    sectionFilled = true;
//    sectionCounter++;
//    sectionStart = start;
//    sectionEnd = end;
//}
//
//// UTILS
//
//uint32_t ceilToPowerOf2(uint32_t i) {
//    i--;
//    i|=(i>>1);
//    i|=(i>>2);
//    i|=(i>>4);
//    i|=(i>>8);
//    i|=(i>>16);
//    return i+1;
//}
//
//void trySwp(int16_t *indices, float *magnitudes, int a, int b) {
//    if(magnitudes[indices[a]]>magnitudes[indices[b]]) {
//        int x = indices[a];
//        indices[a] = indices[b];
//        indices[b] = x;
//    }
//}
//
//void sort(int16_t *indices, float *magnitudes, int size) {
//    indices[0] = 0;
//    for(int i=1; i<size; i++) {
//        indices[i]=i;
//        for(int j=i; j-->0;) {
//            trySwp(indices, magnitudes, j, j+1);
//        }
//    }
//}
//
//bool magComparator(int const & a, int const & b) {
//    return magnitudes[a] > magnitudes[b];
//}
//
//// MAIN
//
//int main()
//{
//    
//    pcBuffer1[0] = '|';
//    pcBuffer1[FREQ_ANALYSER_WIDTH+1] = '|';
//    pcBuffer1[FREQ_ANALYSER_WIDTH+2] = 0;
//    memset(pcBuffer2+1, '-', FREQ_ANALYSER_WIDTH);
//    pcBuffer2[0] = '+';
//    pcBuffer2[FREQ_ANALYSER_WIDTH+1] = '+';
//    pcBuffer2[FREQ_ANALYSER_WIDTH+2] = 0;
//    
//    process_led = 1;
//    
//    pc.cls();
//    pc.cursor(false);
//    pc.locate(0,0);
//    pc.printf("Synchronising Floppy Drives\r\n");
//    
//    Moppy moppy(D1, D0, 38400); // tx, rx, baud
//    
//    pc.printf("Setup Complete\r\n");
//    
//    switch(asyncAnalogToCircularBuffer(AUDIO_PIN, adcBuffer, 2*FFT_SIZE, SAMPLE_RATE_HZ, callback)) {
//        case E_ASYNC_ADC_ACTIVE:
//            error("AsyncADC already in use");
//        case E_DMA_IN_USE:
//            error("DMA already in use");
//        case E_INVALID_BUFFER_SIZE:
//            error("Invalid destination buffer size");
//    }
//    
//    int16_t indices[FFT_SIZE*2];
//            
//    timer.start();
//    
//    pc.locate(0,16);
//    pc.printf("%dHz", BIN_TO_FREQ(1));
//    pc.locate(FREQ_ANALYSER_WIDTH-20,16);
//    pc.printf("%20dHz", BIN_TO_FREQ(FFT_SIZE/2));
//    
//    while(1) {
//        if(sectionFilled) {
//            process_led = 0;
//            
//            timer.reset();
//            
//            //convert to floating point
//            for(int i=sectionStart, j=0; i<=sectionEnd; i++, j+=2) {
//                fftBuffer[j] = (float)adcBuffer[i];
//                fftBuffer[j+1] = 0.0f;
//            }
//                
//            // Calculate FFT if a full sample is available.
//            // Run FFT on sample data.
//            arm_cfft_f32(FFT_BUFFER, fftBuffer, 0, 1);
//            // Calculate magnitude of complex numbers output by the FFT.
//            arm_cmplx_mag_f32(fftBuffer, magnitudes, FFT_SIZE);
//            
//            for(int i=1; i<FFT_SIZE; i++)
//                indices[i]=i;
//            std::sort(indices + 1, indices + (FFT_SIZE/2), magComparator);
//            
//            //REMEMBER: Ignore Indicies[0]!!!!
//            moppy.setFrequency(0, BIN_TO_FREQ(indices[1]));
//            moppy.setFrequency(1, BIN_TO_FREQ(indices[2]));
//            moppy.setFrequency(2, BIN_TO_FREQ(indices[3]));
//            moppy.setFrequency(3, BIN_TO_FREQ(indices[4]));
//            moppy.flush();
//            
//            pc.locate(0, 4);
//            pc.puts(pcBuffer2);
//            memset(pcBuffer1+1, ' ', FREQ_ANALYSER_WIDTH);
//            float max = magnitudes[indices[1]];
//            if(max<1000000) max = 1000000;
//            for(int i=2; i<FFT_SIZE/2; i++) {
//                int j = (i>>FREQ_ANALYSER_SCALAR)+1;
//                if(magnitudes[i] > magnitudes[j])
//                    magnitudes[j] = magnitudes[i];
//            }
//            for(int y=0; y<FREQ_ANALYSER_HEIGHT; y++) {
//                float thresh = max*(FREQ_ANALYSER_HEIGHT-y)/(FREQ_ANALYSER_HEIGHT+1.0f);//((FREQ_ANALYSER_HEIGHT-1)-y)*max/(FREQ_ANALYSER_HEIGHT+1);
//                for(int x=1; x<=FREQ_ANALYSER_WIDTH; x++)
//                    if(pcBuffer1[x]!='#' && magnitudes[x]>thresh)
//                        pcBuffer1[x]='#';
//                pc.locate(0, y+5);
//                pc.puts(pcBuffer1);
//            }
//            pc.locate(0, FREQ_ANALYSER_HEIGHT+5);
//            pc.puts(pcBuffer2);
//            
//            
//            long process_time = timer.read_us();
//            
//            
//            long x = (process_time)/(100*FFT_SIZE/SAMPLE_RATE_HZ);
//            
//            pc.locate(0,2);
//            pc.printf("Process Time:%3d.%02dms  ~%d.%02d%%", process_time/1000, ((process_time+5)/10)%100, x/100, x%100);
////            pc.printf("\r\n%f", magnitudes[indices[1]]);
//            
//            process_led = 1;
//            
//            sectionFilled = false;
//        }
//        sleep();
//    }
//}