#ifndef _MOPPY_H__
#define _MOPPY_H__

#include "mbed.h"

class Moppy {
    
public:
    
    Moppy(PinName tx, PinName rx, int baud);
    
    uint8_t getFloppyDrives() {
        return driveCount;
    }
    
    void setFrequency(int drive, int frequency);
    
    void flush();

    bool silence();
    
private:

    void consumeAndCheck(int event);
    
    Serial serial;
    uint8_t driveCount;
    char* str_buffer;
    uint16_t* freqs;
    bool* pair_changed;
    
    int expectedSyncs;
    event_callback_t read_callback;
    
};

//struct Profile {
//    int minFreq, maxFreq;
//}
//
//class MoppyController {
//public:
//    MoppyController(PinName tx, PinName rx, int baud);
//    
//    uint8_t getDeviceCount();
//    
//    void readProfile(int device, Profile &profile);
//    
//    void setDeviceFrequency(int device, int frequency);;
//    
//    void silence();
//    
//    void flush();
//    
//private:
//    
//    Serial _serial;
//    char* _buffer;
//    int _bufferSize;
//    
//    
//}

#endif // _MOPPY_H__