#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "button_group.hpp"
#include "LogoParisSaclay.h"
#include "fleche.h"
#include "mbed.h"
#include "SRF02.h"

//declarations
TS_StateTypeDef TS_State;

uint16_t x, y;
uint8_t text[30];
uint8_t status;

void page_capteur(void); //0
void page_alarme(void);  //1
void page_accueil(void); //2

int page = 2;
uint8_t idx;
uint8_t dStd = 50;
uint8_t dLim = 40;
uint8_t dCrit = 30;

SRF02 sensor(0xE0,PB_9,PB_8);  // address, SDA, SCL
DigitalOut buzzer(PH_6);


//fonction pour afficher l'image fleche
void drawImage_fleche(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)fleche.data;
    while(y < fleche.height) {
        while(x < fleche.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}


//fonction pour afficher l'image logo
void drawImage_LogoParisSaclay(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)LogoParisSaclay.data;
    while(y < LogoParisSaclay.height) {
        while(x < LogoParisSaclay.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}



/////////////////////
///// PROGRAMME /////
/////////////////////
int main()
{
    //initialisation de l'ecran
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    BSP_LCD_Clear(LCD_COLOR_WHITE);

    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    if (status != TS_OK) { 
        BSP_LCD_Clear(LCD_COLOR_WHITE);
        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
        BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    }
    else {
        BSP_LCD_Clear(LCD_COLOR_WHITE);
        BSP_LCD_SetBackColor(LCD_COLOR_CYAN);
        BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"PROJET INTERFACAGE", CENTER_MODE);
    }

    HAL_Delay(2000);
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    
    BSP_LCD_SetFont(&Font12);
    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);

    //lancement du programme
    while(1) {
    
        //////////////////////////////
        ///// DETECTION CLICS : //////
        //////////////////////////////
        
        BSP_TS_GetState(&TS_State);
        for (idx = 0; idx < TS_State.touchDetected; idx++) 
        {
            x = TS_State.touchX[idx];
            y = TS_State.touchY[idx];
        }
        
        
        //////////////////////////////
        ///// AFFICHAGE PAGES : //////
        //////////////////////////////
        
        //PAGE ACCUEIL VERS PAGE CAPTEUR
        //si page p et clic sur cadre correspondant
        if ((page == 2) && (x>= 65 && x<= 215) && (y>= 55 && y<= 230))
        {
            //reset ecran et coordonnées
            BSP_LCD_Clear(LCD_COLOR_WHITE);
            x = 0;
            y = 0;
            //affichage page p
            page = 0;
            HAL_Delay(300);
        }
        
        //PAGE ACCUEIL VERS PAGE ALARME
        if ((page == 2) && (x>= 265 && x<= 415) && (y>= 55 && y<= 230))
        {
            BSP_LCD_Clear(LCD_COLOR_WHITE);
            x = 0;
            y = 0;
            page = 1;
            HAL_Delay(300);
        }
        
        // PAGE CAPTEUR VERS PAGE D'ACCUEIL
        if ((page == 0) && (x>= 455 && x<= 480) && (y>= 0 && y<= 25))
        {
            BSP_LCD_Clear(LCD_COLOR_WHITE);
            x = 0;
            y = 0;
            page = 2;
            HAL_Delay(300);
        }
        
        // PAGE ALARME VERS PAGE D'ACCUEIL
        if ((page == 1) && (x>= 455 && x<= 480) && (y>= 0 && y<= 25))
        {
            BSP_LCD_Clear(LCD_COLOR_WHITE);
            x = 0;
            y = 0;
            page = 2;
            HAL_Delay(300);
        }
        
        // AFFICHAGE DE LA PAGE D'ACCUEIL
        else if (page == 2)
        {
            page_accueil();
        }
        
        
        /////////////////////////
        ///// MODE CAPTEUR : ////
        /////////////////////////
        
        //REGLAGE DES SEUILS D'ALARME :
        
        //dStd -1
        //en page capteur, si clic sur cadre correspondant
        else if ((page == 0) && (x>= 8 && x<= 55) && (y>= 33 && y<= 85))
        {
            x = 0;
            y = 0;
            //si seuil changeable
            if (dStd >> (dLim+5) && dStd <= 80)
            //modifier en conséquence
            { dStd = dStd - 1; }
            HAL_Delay(200);
        }
           
        //dStd +1  
        else if ((page == 0) && (x>= 188 && x<= 231) && (y>= 33 && y<= 85))
        {
            x = 0;
            y = 0;
            if (dStd >= (dLim+5) && dStd < 80)
            { dStd = dStd + 1; }
            HAL_Delay(200);
        }
            
        //dLim -1
        else if ((page == 0) && (x>= 8 && x<= 51) && (y>= 113 && y<= 160))
        {
            x = 0;
            y = 0;
            if (dLim > (dCrit+5) && dLim <= (dStd-5))
            { dLim = dLim - 1; }
            HAL_Delay(200);
        }

        //dLim +1
        else if ((page == 0) && (x>= 193 && x<= 236) && (y>= 113 && y<= 160))
        {
            x = 0;
            y = 0;
            if (dLim >= (dCrit+5) && dLim < (dStd-5))
            { dLim = dLim + 1; }
            HAL_Delay(200);
        }
            
        //dCrit -1
        else if ((page == 0) && (x>= 8 && x<= 51) && (y>= 193 && y<= 240))
        {
            x = 0;
            y = 0;
            if (dCrit > 20 && dCrit <= (dLim-5))
            { dCrit = dCrit - 1; }
            HAL_Delay(200);
        }
            
            
        //dCrit +1
        else if ((page == 0) && (x>= 193 && x<= 236) && (y>= 193 && y<= 240))
        {
            x = 0;
            y = 0;
            if (dCrit >= 20 && dCrit < (dLim-5))
            { dCrit = dCrit + 1; }
            HAL_Delay(200);
        }
        
        else if (page == 0) 
        {
            // AFFICHAGE DE LA PAGE MODE CAPTEUR
            page_capteur();
            
            
            //LECTURE DU CAPTEUR ET AFFICHAGE DE LA DISTANCE MESUREE
            int distance;
            //lecture du capteur en cm
            distance = sensor.GetCentimeters();
            //affichage sur l'ecran
            BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
            sprintf((char*)text, "Distance = %d cm",distance);
            BSP_LCD_DisplayStringAt(80, LINE(3), (uint8_t *)&text, RIGHT_MODE);
            HAL_Delay(20);
            
            
            //AFFICHAGE DES ALARMES ET DECLENCHEMENT DES BIPS
            if(distance >= dStd){   //distance > a tous les seuils d'alarme (ras)
                buzzer = 0;
            }
            
            //premier seuil
            if(distance < dStd){                //dStd triggered
                //afficher rectangle vert
                BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
                BSP_LCD_FillRect(347, 180, 40, 40);
            }
            else{                               //dStd ok
                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                BSP_LCD_FillRect(347, 180, 40, 40);
            }
            
            //deuxième seuil
            if(distance < dLim){                //dLim triggered
                //afficher rectangle orange
                BSP_LCD_SetTextColor(LCD_COLOR_ORANGE);
                BSP_LCD_FillRect(338, 115, 60, 50);
                //faire bipper buzzer
                if(distance > dCrit){
                    buzzer = 1;
                    HAL_Delay(250);
                    buzzer = 0;
                    HAL_Delay(750);
                }
            }
            else{                               //dLim ok
                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                BSP_LCD_FillRect(338, 115, 60, 50);
                buzzer = 0;
            }
            
            //seuil max
            if(distance < dCrit){               //dCrit triggered
                //afficher rectangle rouge
                BSP_LCD_SetTextColor(LCD_COLOR_RED);
                BSP_LCD_FillRect(330, 45, 80, 55);
                //faire sonner buzzer en continu
                buzzer = 1;
            }
            else{                               //dCrit ok
                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                BSP_LCD_FillRect(330, 45, 80, 55);
                buzzer = 0;
            }
            
        }//fin mode capteur
        
        
        /////////////////////////
        ///// MODE ALARME : /////
        /////////////////////////
        
        else if (page == 1)
        {
            // AFFICHAGE DE LA PAGE MODE ALARME
            page_alarme();
            
            
            //LECTURE DU CAPTEUR ET AFFICHAGE DE LA DISTANCE MESUREE
            int distance;
            //lecture du capteur en cm
            distance = sensor.GetCentimeters();
            sprintf((char*)text, "Distance = %d cm",distance);
            BSP_LCD_DisplayStringAt(80, LINE(3), (uint8_t *)&text, RIGHT_MODE);
            HAL_Delay(20);
            
            
            // ALERTE
            if(distance < 40){                  //alarme triggered
                //afficher rectangle
                BSP_LCD_SetTextColor(LCD_COLOR_RED);
                BSP_LCD_FillRect(165,70,150,150);
                //faire sonner buzzer en continu
                buzzer = 1;
            }
            else{                               //alarme ok
                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                BSP_LCD_FillRect(165,70,150,150);
                buzzer = 0;
            }
            
            //afficher message detection
            sprintf((char*)text, "INTRUSION");
            BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)&text, CENTER_MODE);
            
        }//fin mode alarme
       
    }//fin while
    
}//fin main



/////////////////////////
///// PAGE CAPTEUR //////
/////////////////////////  
void page_capteur ()
{
    page = 0;
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    
    //afficher logo
    drawImage_LogoParisSaclay(0,0);
    
    //afficher titre page
    sprintf((char*)text, "Mode Capteur de recul");
    BSP_LCD_DisplayStringAt(0, LINE(1), (uint8_t *)&text, CENTER_MODE);
    
    //afficher fleche
    drawImage_fleche(447,0);
    
    //ligne de "cadre"
    BSP_LCD_DrawHLine(0,24,480);
    
    
    //ZONE REGLAGE dStd
    //afficher rectangle cadre
    BSP_LCD_DrawRect(8, 33, 228, 74);
    //afficher seuil
    sprintf ((char*)text, "%d", dStd);
    BSP_LCD_DisplayStringAt(110, 51, (uint8_t *)&text, LEFT_MODE);
    //ligne "cadre" -
    BSP_LCD_DrawVLine(51,33,47);
    //afficher -
    sprintf((char*)text, "-");
    BSP_LCD_DisplayStringAt(26, 51, (uint8_t *)&text, LEFT_MODE);
    //ligne "cadre" +
    BSP_LCD_DrawVLine(193,33,47);
    //afficher +
    sprintf((char*)text, "+");
    BSP_LCD_DisplayStringAt(212, 51, (uint8_t *)&text, LEFT_MODE);
    //ligne "cadre" nom du seuil
    BSP_LCD_DrawHLine(8,80,228);
    //afficher nom du seuil
    sprintf((char*)text, "Distance acceptable");
    BSP_LCD_DisplayStringAt(57,87, (uint8_t *)&text, LEFT_MODE);
    
    
    //ZONE REGLAGE dLim
    BSP_LCD_DrawRect(8, 113, 228, 74);
    sprintf((char*)text, "%d", dLim);
    BSP_LCD_DisplayStringAt(110, 131, (uint8_t *)&text, LEFT_MODE);
    BSP_LCD_DrawVLine(51,113,47);
    sprintf((char*)text, "-");
    BSP_LCD_DisplayStringAt(27, 131, (uint8_t *)&text, LEFT_MODE);
    BSP_LCD_DrawVLine(193,113,47);
    sprintf((char*)text, "+");
    BSP_LCD_DisplayStringAt(212, 131, (uint8_t *)&text, LEFT_MODE);
    BSP_LCD_DrawHLine(8,160,228);
    sprintf((char*)text, "Distance limite");
    BSP_LCD_DisplayStringAt(70, 167, (uint8_t *)&text, LEFT_MODE);
    
    //ZONE REGLAGE dCrit
    BSP_LCD_DrawRect(8, 193, 228, 73);
    sprintf((char*)text, "%d", dCrit);
    BSP_LCD_DisplayStringAt(110, 212, (uint8_t *)&text, LEFT_MODE);
    BSP_LCD_DrawVLine(50,193,47);
    sprintf((char*)text, "-");
    BSP_LCD_DisplayStringAt(27, 212, (uint8_t *)&text, LEFT_MODE);
    BSP_LCD_DrawVLine(193,193,47);
    sprintf((char*)text, "+");
    BSP_LCD_DisplayStringAt(212, 212, (uint8_t *)&text, LEFT_MODE);
    BSP_LCD_DrawHLine(8,240,228);
    sprintf((char*)text, "Distance critique");
    BSP_LCD_DisplayStringAt(63, 247, (uint8_t *)&text, LEFT_MODE);
    
    
    //PASTILLE DE BASE
    BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
    BSP_LCD_FillRect(350, 237, 30, 30);
}



///////////////////////
///// PAGE ALARME /////
///////////////////////
void page_alarme()
{
    page = 1;
    
    //afficher logo
    drawImage_LogoParisSaclay(0,0);
    
    //afficher fleche
    drawImage_fleche(447,0);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    
    //ligne de "cadre"
    BSP_LCD_DrawHLine(0,24,480);
    
    //afficher titre page
    sprintf((char*)text, "Mode Alarme de securite");
    BSP_LCD_DisplayStringAt(0, LINE(1), (uint8_t *)&text, CENTER_MODE);
}


////////////////////////
///// PAGE ACCUEIL /////
////////////////////////
    
void page_accueil()
{
    page = 2;
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    
    //afficher logo
    drawImage_LogoParisSaclay(0,0);
    
    //afficher titre page
    sprintf((char*)text, "Page d'accueil");
    BSP_LCD_DisplayStringAt(0, LINE(2), (uint8_t *)&text, CENTER_MODE);
    
    //Mode recul
    //afficher rectangle cadre
    BSP_LCD_DrawRect(65, 55, 150, 175);
    //ligne "cadre" nom du mode
    BSP_LCD_DrawHLine(65,210,150);
    //afficher nom du mode
    sprintf((char*)text, "Capteur de recul");
    BSP_LCD_DisplayStringAt(85, LINE(18), (uint8_t *)&text, LEFT_MODE);
    
    
    //Mode alarme
    BSP_LCD_DrawRect(265, 55, 150, 175);
    BSP_LCD_DrawHLine(265,210,150);
    BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
    sprintf((char*)text, "Alarme de securite");
    BSP_LCD_DisplayStringAt(102, LINE(18), (uint8_t *)&text, CENTER_MODE);
}
