#ifndef Smartlab_Drive_SPRF02
#define Smartlab_Drive_SPRF02

#include "mbed.h"

class SRF02

{
private:
    uint8_t deviceAddess;
    static const int CLOCK_RATE = 100000;

    static const uint8_t COMMAND_REGISTER = 0x00;
    
    static const uint8_t Range = 0x02;
    static const uint8_t Autotune  = 0x04;
    
    static const uint8_t REAL_RANGING_INCHES = 0x50;
    static const uint8_t REAL_RANGING_CENTIMETERS = 0x51;
    static const uint8_t REAL_RANGING_SECONDS = 0x52;

    //static const float DefaultWait = 0.07;

    I2C i2c_bus;
    
    int GetValue(uint8_t command, uint8_t mode);

public :
    SRF02(uint8_t I2C_address,PinName sda, PinName scl);

    int GetMinimumRange();

    int GetCentimeters();

    int GetInches();

    int GetMicroSeconds();
    
    bool ChangeAddress(uint8_t newAddress);
};

#endif