#include "mbed.h"

#define TAILLEWRITE 22
#define TAILLEREAD  20
Serial serial(PC_10,PC_11,115200);
Serial pc(SERIAL_TX, SERIAL_RX, 115200);
event_callback_t receptionCallback;
bool consigne = false;

char bufferWrite[TAILLEWRITE] = "3.1415/15000/50000";
char bufferRead[TAILLEREAD]; 

void recupererConsigne(int events);

void envoyerPosition()
{
    serial.printf("%s", bufferWrite);   
}

int main() {
    
    Ticker t;
    t.attach(&envoyerPosition, 0.1f);
    
    receptionCallback.attach(recupererConsigne); 
    serial.read((uint8_t*)bufferRead, TAILLEREAD, receptionCallback, SERIAL_EVENT_RX_COMPLETE);
    while(1)
    {
         pc.printf("Consigne lu : %s\n\r", bufferRead);
        if(consigne == true)
        {
               //pc.printf("Consigne lu : %s\n\r", bufferRead);
               consigne = false;
        }   
    }
}


void recupererConsigne(int events)
{
    consigne = true;
    serial.read((uint8_t*)bufferRead, TAILLEREAD, receptionCallback, SERIAL_EVENT_RX_COMPLETE);
    
}