#include "mbed.h"

#include "hardware.h"
#include "odometrie.h"
#include "reglages.h"
#include "commande_moteurs.h"
#include "deplacement.h"

#define TAILLEWRITE 22
#define TAILLEREAD  20
Serial serial(PC_10,PC_11,115200);
Serial pc(SERIAL_TX, SERIAL_RX, 115200);
event_callback_t receptionCallback;
bool consigne = false;

char bufferWrite[TAILLEWRITE] = "3.1415/15000/50000";
char bufferRead[TAILLEREAD]; 

void recupererConsigne(int events);

void envoyerPosition()
{
    serial.printf("%s", bufferWrite);   
}

int main()
{
    //ini
    init_odometrie();
    init_hardware();
    srand(time(NULL));
    motors_on();
    AnalogIn Ain(A0);
    if(Ain.read()<0.5){
          return 0;
    }
    /*DigitalIn depart(USER_BUTTON);
    //Pause pour sauver le robot et l'ordi
    while(depart);*/
    deplacement robot;
    robot.bouton();
    Ticker asser;
    Timer t;
    t.start();
    //asser.attach(callback(&robot,&deplacement::asservissement),0.01);
    //robot.ligne_droite_v2(210000);

    Ticker t;
    t.attach(&envoyerPosition, 0.1f);
    
    receptionCallback.attach(recupererConsigne); 
    serial.read((uint8_t*)bufferRead, TAILLEREAD, receptionCallback, SERIAL_EVENT_RX_COMPLETE);
    
    float vitesseD;
    float vitesseG;
    
    while(1)
    {
        pc.printf("Consigne lu : %s\n\r", bufferRead);
        conversion(&vitesseD, &vitesseG);
        commande_vitesse(),
    }
    
    //printf("x : %lf,y : %lf,angle : %lf\n",get_x_actuel(),get_y_actuel(),get_angle());*/
    return 0;
}



void recupererConsigne(int events)
{
    consigne = true;
    serial.read((uint8_t*)bufferRead, TAILLEREAD, receptionCallback, SERIAL_EVENT_RX_COMPLETE);
    
}

void conversion(float *vd, float *vg)
{
    const char seps[2] = "/";
    int i = 1;
    const char sepv[2] = ",";
    float aux1 = 0;
    float aux2 = 0;
    int j=0;
    
    float aux = bufferRead[0];
    while(bufferRead[i] != sepv[0])
    {
        aux *= 10;
        aux = bufferRead[i] - 48;
        i++;
    }
    j=i;
    i++;
    while(bufferRead[i] != seps[0])
    {
        aux1 = bufferRead[i] - 48;
        aux1 = aux1/(pow(10,(i-j)));
        aux2 = aux1+aux2;
        i++;
    }
    *vd = aux + aux2;
    
    printf("vd : %lf",&vd);
    
    i++;    
    float aux = bufferRead[i];
    i++;
    aux1, aux2 = 0, 0;
    while(bufferRead[i] != sepv[0])
    {
        aux *= 10;
        aux = bufferRead[i] - 48;
        i++;
    }
    j=i;
    i++;
    while(bufferRead[i] != seps[0])
    {
        aux1 = bufferRead[i] - 48;
        aux1 = aux1/(pow(10,(i-j)));
        aux2 = aux1+aux2;
        i++;
    }
    *vg = aux + aux2;
    
    printf("vg : %lf",&vg);
}
