//Test of cheap 13.56 Mhz RFID-RC522 module from eBay
//This code is based on Martin Olejar's and Thomas Kirchner's MFRC522 libraries. Minimal changes
//Adapted for FRDM-K64F from Freescale, in 07/21/2014 by Clovis Fritzen.

#include "mbed.h"
#include "MFRC522.h"
#include "beep.h"
#include "TextLCD.h"

// FRDM-K64F (Freescale) Pin for MFRC522 reset
#define MF_RESET    PTD0

// Defining the serial ports for PC and Bluetooth
#define SERIAL_1  
Serial pc(USBTX, USBRX);
#ifdef SERIAL_1
Serial blue(PTC15,PTC14);          // HC05
#endif
#ifdef SERIAL_2
Serial blue(PTC17,PTC16);         // TX = P14  RX = P13
#endif


DigitalOut LedGreen(LED2), LedRed(LED1);
TextLCD lcd(PTB9, PTA1, PTB23, PTA2, PTC2, PTC3); // rs, e, d4-d7
Beep buzzer(PTA0);
Timer timeBetweenCards;
char tagname;
char * cardtypetest;
char cardid;



//MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);
MFRC522    RfChip   (PTD2, PTD3, PTD1, PTE25, PTD0);


int main(void) {
  
  blue.baud(9600);
  pc.baud(9600);
  LedRed= 0;
  pc.printf("Bluetooth and RFID Started\r\n");

  // Init. RC522 Chip
  RfChip.PCD_Init();

  while (true) {
    
    lcd.locate(0,0);
    lcd.printf("%.2f seconds \n", timeBetweenCards.read());
    tagname = '\0';
    LedRed= 1;
    LedGreen = 1;

    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      //wait_ms(100);
      continue;
    }

    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      //wait_ms(100);
      
      continue;
      
    }
    
    // When a card is detected, a Green Led flashes and a buzzers bips!
    blue.printf("%f seconds \n", timeBetweenCards.read());
    timeBetweenCards.start();
    LedGreen = 0; 
    buzzer.beep(5000,0.3);

    // Print Card UID
    printf("\n\r");
    printf("Card UID: ");
    
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      printf(" %X02", RfChip.uid.uidByte[i]);
      cardid= RfChip.uid.uidByte[i];
      blue.printf(" %X02 ", (char *) cardid);
      tagname= RfChip.uid.uidByte[i]+ tagname;
      blue.putc(tagname);
      lcd.locate(0,1);
      lcd.printf("Tag id: %.0d\n", tagname); 
      
    }
    printf("\n\r");
    if (tagname == 226) {
        printf ("BLUE Keychain");
        printf("\n\r");
        } else {
            if (tagname == 92) {
                
        printf ("White card");
        printf("\n\r");
        }
        }
        
            
        
        printf("Decimal tag ID:  %d \n\r", tagname);   

    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    cardtypetest= RfChip.PICC_GetTypeName(piccType);
    blue.printf("PICC Type: %s \n\r",(char *) cardtypetest);
    //wait_ms(100);
  }
}