/*
mbed touchpad & accelerometer experiments.

CPV, 14/09/2009
*/


#include "my_pwm_out.h"


using namespace mbed;


MyPwmOut::MyPwmOut(PinName pin, const char *name) : PwmOut(pin,name)
{
  m_channel = (pin&0x0000001f) + 1; // Between 1 and 6.
  m_p_mrx = (uint32_t *)&LPC_PWM1->MR0 + m_channel; // Select MRx register for this channel.
  if (m_channel>=4) m_p_mrx += 6; // Skip CR registers if needed.
  m_pclk = get_pclk();
}


float MyPwmOut::get_pclk(void)
{
  float Fin = 12000000; // From the mbed schematic.
  uint32_t m = 1 + (LPC_SC->PLL0STAT&0x00007fff);
  uint32_t n = 1 + ((LPC_SC->PLL0STAT&0x00ff0000)>>16);
  float Fcco = 2*m*Fin/n; // PLL frequency.
  float cclk = Fcco/(1+(LPC_SC->CCLKCFG&0x000000ff)); // Get CCLK from Fcco.

  m_pclk = cclk/4;
  switch ((LPC_SC->PCLKSEL0&0x00003000)>>12)
  {
    case 0: m_pclk = cclk/4; break;
    case 1: m_pclk = cclk; break;
    case 2: m_pclk = cclk/2; break;
    case 3: m_pclk = cclk/8; break;
  }

  //printf("Fin = %0.0f\n",Fin);
  //printf("m = %d, n = %d\n",m,n);
  //printf("Fcco = %0.0f\n",Fcco);
  //printf("CLKC = %0.0f\n",cclk);
  //printf("PLCK = %0.0f\n",m_pclk);
  
  return m_pclk;
}


void MyPwmOut::set(float period, float duty_cycle)
{
  LPC_PWM1->MR0 = period*m_pclk; // Set new period in seconds.
  *m_p_mrx = duty_cycle * LPC_PWM1->MR0; // Set new duty-cycle.
  LPC_PWM1->LER |= (1<<m_channel)|1; // Use MRx & MR0 value on next TC reset.
}

