/*
mbed touchpad & accelerometer experiments.

CPV, 14/09/2009
*/


#ifndef __MY_PWM_OUT_H__
#define __MY_PWM_OUT_H__


#include "PwmOut.h"
namespace mbed
{

class MyPwmOut : public PwmOut
{
public:
  /* Constructor: PwmOut
   *  Create a PwmOut connected to the specified pin
   *
   * Variables:
   *  pin - PwmOut pin to connect to
   */
  MyPwmOut(PinName pin, const char *name = NULL);
  
  /* Function: set
   *  Set the PWM period, specified in seconds (float)
   *  and the ouput duty-cycle, specified as a percentage (float)
   *
   * Variables:
   *  period - A floating-point value representing the output period, 
   *    specified in seconds.
   *  duty_cycle - A floating-point value representing the output duty-cycle, 
   *    specified as a percentage. The value should lie between
   *    0.0f (representing on 0%) and 1.0f (representing on 100%).
   *    Values outside this range will be saturated to 0.0f or 1.0f.     
   */
  void set(float period, float duty_cycle);
  
  float get_pclk(void);

protected:
  float m_pclk;
  uint32_t m_channel;
  uint32_t *m_p_mrx;
};

} // namespace mbed

#endif // __MY_PWM_OUT_H__
