/*
mbed touchpad & accelerometer experiments.

CPV, 14/09/2009
*/

#include "mbed.h"
#include "touchpad.h"
#include "accelerometer.h"
#include "my_pwm_out.h"


// Pin definitions.
#define ACC0  p20
#define ACC1  p19
#define X0  p18
#define Y0  p17
#define X1  p16
#define Y1  p15


// Some global objects.
DigitalOut led1(LED1);
Ticker timer1; // Sample clock.
Ticker timer2; // "keyboard" scan clock.
Ticker timer3; // LED clock.
Touchpad tp(X0,X1,Y0,Y1);
Accelerometer2D acc(ACC0,ACC1,10);
MyPwmOut buzzer(p21); // Subclassed from PwmOut.


float DutyCycle = 0.0; // No sound.
int Period = 1136; // in us => 880 Hz.
int FlagUpdateSound = 0;

// Periods in us.
const int freq[4][6] = 
{
  { 1607, 1517, 1432, 1351, 1276, 1204 },
  { 1136, 1073, 1012, 956, 902, 851 },
  { 804, 758, 716, 676, 638, 602 },
  { 568, 536, 506, 478, 451, 426 },
};


void sample(void)
{
  tp.tick();
  acc.tick();
}


void scan_keyboard(void)
{
  if (tp.hotspot()>0)
  {
    int x = tp.get_hotspot_x();
    int y = tp.get_hotspot_y();
    Period = freq[y][x]*(1.0+acc.read(0)/64000.0);
    DutyCycle = 0.5 + acc.read(1)/32000.0;
    FlagUpdateSound = 1;
  }
  else
  {
    if (DutyCycle!=0.0) 
    {
      DutyCycle = 0.0;
      FlagUpdateSound = 1;
    }
  }
}


void toggle_led(void)
{
  if (led1==1) led1 = 0;
  else led1 = 1;
}


int main() 
{
  printf("\n");
  printf("-=o Touch, Shake & Whine o=-\n");
  printf("\n");
  printf("mbed touchpad & 2D accelerometer demo\n");
  printf("\n");
  printf("A buzzer is driven by a PWM signal to generate musical notes.\n");
  printf("A touchpad is used as a keypad, divided in a 6 by 4 matrix.\n");
  printf("The position on the touchpad determines the note played by the\n");
  printf("buzzer. A 2-axis accelerometer is used to modulate the frequency\n");
  printf("and the duty-cycle of the PWM signal.\n");
  printf("A blinking LED shows that the system is running.\n");
  printf("\n");
  printf("Touch & shake the circuit to make it whine.\n");
  printf("\n");
  printf("Demonstrates:\n");
  printf("- the use of a resistive touchpad\n");
  printf("- the use of a 2D accelerometer\n");
  printf("- the use of PWM for smooth frequency generation\n");
  printf("- on-the-fly pin function switching\n");
  printf("- mbed \"base\" class extension\n");
  printf("\n");
  printf("CPV, 14/09/2009\n");
  printf("\n");
  printf("     -end-\n\n");
  
  led1 = 1; // LED on.
  
  timer1.attach_us(&sample,1000); // Sample every 1 ms.
  timer2.attach_us(&scan_keyboard,10000); // Scan the touchpad every 10 ms.
  timer3.attach_us(&toggle_led,500000); // Toggle the LED every 500 ms.

  while (1)
  {
    if (FlagUpdateSound==1)
    {
      // Only update period & duty-cycle when new data is available.
      FlagUpdateSound = 0;
      buzzer.set(Period/1000000.0,DutyCycle);
    }
  }
}
