#include "mbed.h"
#include "FastPWM.h"
#include "atmegatron.h"


uint32_t sample_rate = 64000;
FastPWM audio1(PTD1,1);
FastPWM audio2(PTD3,1);

Ticker tick;

DigitalOut led_green(PTE24);
DigitalOut led_red(PTB20);

DigitalIn encoder1_a(PTA0); // phase A
DigitalIn encoder1_b(PTE27); // phase B
DigitalIn encoder1_k(PTD2); // integrated pushbutton

DigitalIn encoder2_a(PTC4); // phase A
DigitalIn encoder2_b(PTE25); // phase B
DigitalIn encoder2_k(PTD0); // integrated pushbutton

AnalogIn pot2(A5);
AnalogIn pot3(A4);
AnalogIn pot4(A3);
AnalogIn pot5(A2);
AnalogIn pot6(A1);
AnalogIn pot7(A0);


int main(void)
{
    // Systick at 1 kHz.
    tick.attach_us(&SysTick_Handler,1000); 

    // Setup PWM.
    audio1.period_us(1000000.0/sample_rate);
    audio1.pulsewidth_us(0.5*1000000.0/sample_rate); // 50%
    audio2.period_us(1000000.0/sample_rate);
    audio2.pulsewidth_us(0.5*1000000.0/sample_rate); // 50%
    
    // Setup rotary encoders.
    encoder1_a.mode(PullUp);
    encoder1_b.mode(PullUp);
    encoder1_k.mode(PullUp);
    encoder2_a.mode(PullUp);
    encoder2_b.mode(PullUp);
    encoder2_k.mode(PullUp);
    
    // Initialize random number generator.
    randomSeed(0); // TODO: find a better seed.

    // Sound engin setup.
    setup();
    
    while (true) 
    {
        loop_priority_low();
        // The idea is to call loop_priority_high from the systick ISR to
        // fix the sample calculation rate at a known value (1 kHz).
        //loop_priority_high();
    }
}
