/*
Copyright 2013 Paul Soulsby www.soulsbysynths.com
    This file is part of Atmegatron.

    Atmegatron is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Atmegatron is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmegatron.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __ATMEGATRON_H__
#define __ATMEGATRON_H__

#ifdef __cplusplus
extern "C" {
#endif

#define __HAS_ARPEGGIATOR__


#include <stdint.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


typedef uint8_t byte;
typedef bool boolean;
typedef uint8_t uchar;
typedef int8_t sample_t;


#define MEM_PATCHSIZE  (19)    //size of flash mem patch
#define CTRL_FILT  (0)         //digital control nums
#define CTRL_Q  (1)
#define CTRL_ENV  (2)
#define CTRL_LFO  (3)
#define CTRL_AMP  (4)
#define CTRL_FX  (5)
#define FUNC_WAVE  (0)        //function nums
#define FUNC_FILT  (1)
#define FUNC_FENVA  (2)
#define FUNC_FENVDR  (3)
#define FUNC_FENVS  (4)
#define FUNC_AENVA  (5)
#define FUNC_AENVD  (6)
#define FUNC_AENVS  (7)
#define FUNC_AENVR  (8)
#define FUNC_LFOTYPE  (9)
#define FUNC_LFOSPEED  (10)

#ifdef __HAS_ARPEGGIATOR__
#define FUNC_ARPTYPE  (11)
#define FUNC_ARPSPEED  (12)
#include "arpeggiator.h"
#endif // __HAS_ARPEGGIATOR__

#define FUNC_PORTA  (13)
#define FUNC_BITCRUSH  (14)
#define FUNC_MEM  (15)        
#define WAVE_LEN  (32)        //length of wavetable
#define POLL_HARD  (1)        //poll the function/val dials and digital controls
#define POLL_MIDI  (1)        //poll the midi input
#define POLL_TEST  (0)        //test mode

#define FUNC_MAX  (16)
#define CTRL_MAX  (6)
#define RED  false
#define GREEN  true


#include "systick.h"
#include "util.h"
#include "serial.h"
#include "keyboard.h"
#include "eeprom.h"
#include "master.h"
#include "waveforms.h"
#include "distortion.h"
#include "flange.h"
#include "bitcrush.h"
#include "lfo.h"
#include "filter.h"
#include "amplitude.h"
#include "envelope.h"
#include "envelope2.h"
#include "pwm.h"
#include "midi.h"
#include "pitch.h"
#include "memory.h"
#include "hardware.h"
#include "testmode.h"
#include "user_interface.h"

void setup(void);
void loop_priority_low(void);
void loop_priority_high(void);

#ifdef __cplusplus
}
#endif


#endif // __ATMEGATRON_H__
