#include "mbed.h"
#include "LedMatrix.h"
 

CLedMatrix matrix;
Ticker matrixRefresh;
DigitalOut led16(P0_10,0);
LedMatrixColor_t color_global;
uint32_t ms = 0;
uint32_t debug_ms = 0;


void tickLed(void)
{
    static int i = 0;
    // Color is global so the debug LED can use it too.
    color_global = (i&0x10)? red : green; // Toggle color.
    matrix.putPixel(i&0xf,color_global); // Set pixel.
    i--; // Spin clockwise.
}


void systick(void)
{
    matrix.tick();
    ms += 1;

    debug_ms += 1;
    if (debug_ms==250)
    {
        matrix.debugLed(color_global==green?red:green);
    }
    else if (debug_ms==500)
    {
        matrix.debugLed(black);
    }
    else if (debug_ms>=1000)
    {
        debug_ms = 0;
    }
}

 
int main(void) 
{
    uint8_t wait = 62;
    matrix.debugLedEnable(true);
    
    // The debug LED uses a Ticker object, the LED ring uses wait_ms for timing.
    
    matrixRefresh.attach_us(&systick,1000);
    
    while (1)
    {
        tickLed();
        wait_ms(wait);
        // 16 LEDs evenly distributed over 1000 ms requires
        // an average on time of 62.5 ms per LED.
        wait = wait==63? 62 : 63;
    }
}
