/*
 * LedMatrix.cpp
 *
 *  Created on: 25 january 2016
 *      Author: CPV
 */

#include "mbed.h"
#include "LedMatrix.h"

#define MATRIX_ROWS  (4)
#define MATRIX_COLUMNS  (4)


DigitalOut led17g(CENTER_LED_X,1);
DigitalOut led17r(CENTER_LED_Y,1);


DigitalInOut ledMatrixRows[MATRIX_ROWS] = 
{
    DigitalInOut(P0_15,PIN_INPUT,PullNone,0),
    DigitalInOut(P0_13,PIN_INPUT,PullNone,0),
    DigitalInOut(P0_16,PIN_INPUT,PullNone,0),
    DigitalInOut(P0_7,PIN_INPUT,PullNone,0)
};
/*DigitalInOut row0(P0_15,PIN_INPUT,PullNone,0);
DigitalInOut row1(P0_13,PIN_INPUT,PullNone,0);
DigitalInOut row2(P0_16,PIN_INPUT,PullNone,0);
DigitalInOut row3(P0_7,PIN_INPUT,PullNone,0);*/


DigitalInOut ledMatrixColumns[MATRIX_COLUMNS] = 
{
    DigitalInOut(P0_9,PIN_INPUT,PullNone,0),
    DigitalInOut(P0_8,PIN_INPUT,PullNone,0),
    DigitalInOut(P0_17,PIN_INPUT,PullNone,0),
    DigitalInOut(P0_14,PIN_INPUT,PullNone,0)
};
/*DigitalInOut col0(P0_9,PIN_INPUT,PullNone,0);
DigitalInOut col1(P0_8,PIN_INPUT,PullNone,0);
DigitalInOut col2(P0_17,PIN_INPUT,PullNone,0);
DigitalInOut col3(P0_14,PIN_INPUT,PullNone,0);*/


CLedMatrixPixel pixels[PIXELS] =
{
    CLedMatrixPixel(0,0), // LED1
    CLedMatrixPixel(0,1), // LED2
    CLedMatrixPixel(0,2), // LED3
    CLedMatrixPixel(0,3), // LED4
    CLedMatrixPixel(1,0), // LED5
    CLedMatrixPixel(1,1), // LED6
    CLedMatrixPixel(1,2), // LED7
    CLedMatrixPixel(1,3), // LED8
    CLedMatrixPixel(2,0), // LED9
    CLedMatrixPixel(2,1), // LED10
    CLedMatrixPixel(2,2), // LED11
    CLedMatrixPixel(2,3), // LED12
    CLedMatrixPixel(3,0), // LED13
    CLedMatrixPixel(3,1), // LED14
    CLedMatrixPixel(3,2), // LED15
    CLedMatrixPixel(3,3), // LED16
    CLedMatrixPixel(MATRIX_ROWS,MATRIX_COLUMNS), // LED17 (not in the matrix)
};


void CLedMatrix::initialise(void)
{
    m_acitvePixel = 0;
    m_maxPixel = PIXELS;
}


void CLedMatrix::putPixel(uint8_t nr, LedMatrixColor_t color) 
{ 
    if (nr<PIXELS) pixels[nr] = color; 
}


void CLedMatrix::set(CLedMatrixPixel pixel, LedMatrixColor_t color)
{
    if (pixel.x()>=MATRIX_ROWS && pixel.x()>=MATRIX_COLUMNS)
    {
        // Special treats for CENTER_LED.
        setCenterLed(color);
    }
    else if (color==black)
    {
        // Black is achieved by making the pixel pins inputs.
        ledMatrixRows[pixel.x()].input();
        ledMatrixColumns[pixel.y()].input();
    }
    else
    {
        // Red, green & orange require the pixel pins to be outputs.
        ledMatrixRows[pixel.x()].output();
        ledMatrixColumns[pixel.y()].output();
        switch (color)
        {
            case red:
                ledMatrixRows[pixel.x()] = 1;
                ledMatrixColumns[pixel.y()] = 0;
                break;
        
            case green:
                ledMatrixRows[pixel.x()] = 0;
                ledMatrixColumns[pixel.y()] = 1;
                break;
        
            case orange:
                ledMatrixRows[pixel.x()] = 1;
                ledMatrixColumns[pixel.y()] = 1;
                break;
        }
    }
}


void CLedMatrix::setCenterLed(LedMatrixColor_t color)
{
    switch (color)
    {
    case black:
        led17r = 1;
        led17g = 1;
        break;

    case red:
        led17r = 0;
        led17g = 1;
        break;

    case green:
        led17r = 1;
        led17g = 0;
        break;

    case orange:
        led17r = 0;
        led17g = 0;
        break;
    }
}


void CLedMatrix::tick(void)
{
    set(pixels[m_acitvePixel],black); // Deactivate current LED.
    m_acitvePixel += 1; // Increment LED counter.
    if (m_acitvePixel>=m_maxPixel) m_acitvePixel = 0; // Wrap around if needed.
    set(pixels[m_acitvePixel],pixels[m_acitvePixel].color()); // Activate new LED.
}
